/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.db.definition.QueryIteratorDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.Scope;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * singlefalsełꍇɂ̂݁Ã\bh͍쐬܂B
 * 
 * @author Yasuo Nakanishi
 */
public class NextMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private QueryIteratorDotNet fIterator = null;

    public NextMethodDotNet(final BlancoDbObjectStorageDotNet storage,
            final QueryIteratorDotNet iterator) {
        super("Next");
        this.storage = storage;
        this.fIterator = iterator;
    }

    /**
     * VOLłꍇɂ protectedƂ܂B
     */
    protected Scope getScope() {
        if (fIterator.isSingle()) {
            return Scope.PROTECTED;
        } else {
            return Scope.PUBLIC;
        }
    }

    public void setupSignature() {
        setReturnType(new IgType("bool"));

        getJavaDoc().addLine("J[\݂̈ʒu1sֈړ܂B");

        getJavaDoc().addLine("");
        if (fIterator.isSingle()) {
            getJavaDoc().addLine("VOLȂ̂ŃXR[vprotectedƂ܂B");
        }
        getJavaDoc().addReturn("V݂̍sLȏꍇtrueAȏ̍sȂꍇfalseB");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // resultSetmۂł΂AIexecuteQueryĂяo܂B
        implementor.addLine("if (fResultSet == null) {");
        implementor.addStatement("ExecuteQuery()");
        implementor.addLine("}");

        implementor.addLine("try {");
        implementor.addLine("return fResultSet.Read();");
        implementor.addLine("} catch (SqlException ex) {");
        implementor.addLine("throw BlancoDbUtil.ConvertToBlancoException(ex);");
        implementor.addLine("}");
    }
}