/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import blanco.db.util.method.ConvertToBlancoExceptionMethodDotNet;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Type;

/**
 * blancoDbʓIɗp郆[eBeBNXB
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2006.03.02
 * @author IGA Tosiki
 */
public class BlancoDbUtilClassDotNet extends ClassExpander {
    /**
     * ̃NXg̃NX
     */
    public static final String CLASS_NAME = "BlancoDbUtil";

    private BlancoDbObjectStorageDotNet storage = null;

    public BlancoDbUtilClassDotNet(final BlancoDbObjectStorageDotNet storage,
            final Type argType) {
        super(argType);
        this.storage = storage;
    }

    protected void expandClassStruct() {
        getJavaDoc().addLine("blancoDbʓIɗp郆[eBeBNXB");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("̃NXblancoDb\[XR[hŗp܂B");
        getJavaDoc().addLine(
                "̃NX blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("@since 2006.06.30");
        getJavaDoc().addLine("@author blanco Framework");

        addMethod(new ConvertToBlancoExceptionMethodDotNet(storage));
    }
}