/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.collector;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import blanco.db.conf.BlancoDbMetadataDotNet;
import blanco.db.conf.TableDotNet;
import blanco.db.definition.FieldFactoryDotNet;
import blanco.db.definition.TableFieldDotNet;
import blanco.db.definition.TableGatewayDotNet;

/**
 * @author Yasuo Nakanishi
 */
public class GatewayCollectorDotNet {
    private DatabaseServiceDotNet _databaseService = null;

    private List _resultList = new ArrayList();

    private FieldFactoryDotNet _factory = new FieldFactoryDotNet();

    private BlancoDbMetadataDotNet _metadata = null;

    public GatewayCollectorDotNet(final DatabaseServiceDotNet databaseService) {
        _databaseService = databaseService;
    }

    public List collect(final BlancoDbMetadataDotNet metadata)
            throws SQLException {
        _metadata = metadata;

        collectTableNames();

        for (int i = 0; i < _metadata.getTableCount(); i++) {
            collectTableFields(_metadata.getTable(i));
        }
        return _resultList;
    }

    private void collectTableFields(final TableDotNet table)
            throws SQLException {
        final TableGatewayDotNet tableGateway = new TableGatewayDotNet(table
                .getName());
        final ArrayList fields = getTableFields(table);

        for (int j = 0; j < fields.size(); j++) {
            tableGateway.addField((TableFieldDotNet) fields.get(j));
        }
        _resultList.add(tableGateway);
    }

    private Map getPrimaryKeyMap(final TableDotNet table) throws SQLException {
        Map result = null;
        if (table.hasKeyField()) {
            final Iterator iterator = table.getKeyFieldItrator();
            result = new Hashtable();
            String key = "";
            for (short i = 0; iterator.hasNext(); i++) {
                key = (String) iterator.next();
                result.put(key, new Short(i));
            }
        } else {
            result = _databaseService.getPrimaryKeyMap(table.getName());
        }
        return result;
    }

    private TableFieldDotNet createField(final Map keys,
            final ResultSet resultSet) throws SQLException {
        final TableFieldDotNet result = _factory.createTableField(resultSet);
        if (result != null && keys.containsKey(result.getName())) {
            final short sequence = ((Short) keys.get(result.getJdbcName()))
                    .shortValue();
            result.setPrimaryKeySeq(sequence);
        }
        return result;
    }

    private DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return _databaseService.getDatabaseMetaData();
    }

    public ArrayList getTableFields(final TableDotNet table)
            throws SQLException {
        final String catalog = _databaseService.getCatalog();

        final ArrayList listColumns = new ArrayList();
        final Map keys = getPrimaryKeyMap(table);

        final String tableName = table.getName();
        ResultSet rs = null;
        try {
            try {
                rs = getDatabaseMetaData().getColumns(catalog, null, tableName,
                        null);
            } catch (SQLException ex) {
                throw new IllegalArgumentException("P\[" + tableName
                        + "]̏WĂƂɗO܂B" + ex.toString());
            }

            try {
                for (; rs.next();) {
                    listColumns.add(createField(keys, rs));
                }
            } catch (SQLException ex) {
                final String columnName = rs.getString("COLUMN_NAME");
                final String typeName = rs.getString("TYPE_NAME");
                throw new IllegalArgumentException("P\[" + tableName + "]̗["
                        + columnName + "]̏ĂƂSQLO܂B"
                        + "TYPE_NAME(" + typeName + ")" + ex.toString());
            } catch (IllegalArgumentException ex) {
                final String columnName = rs.getString("COLUMN_NAME");
                final String typeName = rs.getString("TYPE_NAME");
                throw new IllegalArgumentException("P\[" + tableName + "]̗["
                        + columnName + "]̏ĂƂɓ͗O܂B"
                        + "TYPE_NAME(" + typeName + ")" + ex.toString());
            }
        } finally {
            if (rs != null) {
                rs.close();
            }
        }
        return listColumns;
    }

    private void collectTableNames() throws SQLException {
        final List tables = _databaseService.getTableNameList();
        for (int i = 0; i < tables.size(); i++) {
            _metadata.addTable(new TableDotNet((String) tables.get(i)));
        }
    }
}