/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.db.definition.QueryFieldDotNet;
import blanco.db.definition.TableFieldDotNet;
import blanco.ig.expander.IgValue;

/**
 * CallerC^tF[X\܂B
 * 
 * @author IGA Tosiki
 */
public class CallQueryDotNet extends AbstractQueryDotNet {
    /**
     * CallableStatementŗp܂B
     */
    private final List _outParameterList = new ArrayList();

    private final List _fieldList = new ArrayList();

    public CallQueryDotNet(final String name) {
        super(name);
    }

    public void addOutParameter(final IgValue value) {
        _outParameterList.add(value);
    }

    public Iterator getOutParameterIterator() {
        return _outParameterList.iterator();
    }

    public List getOutParameterList() {
        return _outParameterList;
    }

    public void addField(final QueryFieldDotNet field) {
        _fieldList.add(field);
    }

    public TableFieldDotNet getField(final int index) {
        return (TableFieldDotNet) _fieldList.get(index);
    }

    public int getFieldCount() {
        return _fieldList.size();
    }

    public Iterator getFieldIterator() {
        return _fieldList.iterator();
    }
}