/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbDefinitionDotNet {
    private String _name = "";

    private List _tableGateways = new ArrayList();

    private List _queryIterators = new ArrayList();

    private List _queryInvokers = new ArrayList();

    private List _queryCallers = new ArrayList();

    public BlancoDbDefinitionDotNet(String name) {
        _name = name;
    }

    public String getName() {
        return _name;
    }

    public void addTableGateway(final TableGatewayDotNet gateway) {
        _tableGateways.add(gateway);
    }

    public int getTableGatewayCount() {
        return _tableGateways.size();
    }

    public TableGatewayDotNet getTableGateway(final int index) {
        return (TableGatewayDotNet) _tableGateways.get(index);
    }

    public Iterator getTableGatewayIterator() {
        return _tableGateways.iterator();
    }

    public void addQueryIterator(final QueryIteratorDotNet iterator) {
        _queryIterators.add(iterator);
    }

    public Iterator getQueryIteratorIterator() {
        return _queryIterators.iterator();
    }

    public void addQueryInvoker(final QueryInvokerDotNet invoker) {
        _queryInvokers.add(invoker);
    }

    public Iterator getQueryInvokerIterator() {
        return _queryInvokers.iterator();
    }

    public void addQueryCaller(QueryCallerDotNet caller) {
        _queryCallers.add(caller);
    }

    public Iterator getQueryCallerIterator() {
        return _queryCallers.iterator();
    }

    public void setIteratorList(final List invokerList) {
        _queryIterators = invokerList;

    }

    public void setInvokerList(final List invokerList) {
        _queryInvokers = invokerList;
    }

    public void setCallerList(final List callerList) {
        _queryCallers = callerList;
    }

    public void setGatewayList(final List gatewayList) {
        _tableGateways = gatewayList;
    }

    public int getTargetObjectCount() {
        return _tableGateways.size() + _queryIterators.size()
                + _queryInvokers.size() + _queryCallers.size();

    }
}