/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import blanco.ig.expander.IgType;

/**
 * @author t.iga
 * @author Yasuo Nakanishi
 */
public class TableFieldDotNet extends AbstractFieldDotNet {
    private boolean _primaryKey = false;

    private short _primaryKeySequence = 0;

    public TableFieldDotNet(final IgType type, final String columnName) {
        super(type, columnName);
    }

    public void setPrimaryKeySeq(final short sequence) {
        _primaryKey = true;
        _primaryKeySequence = sequence;
    }

    public short getPrimaryKeySeq() {
        return _primaryKeySequence;
    }

    public boolean isPrimaryKey() {
        return _primaryKey;
    }
}