/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class GetStatementMethodDotNet extends MethodExpander {
    private IgValue fStatement = null;

    public GetStatementMethodDotNet(final BlancoDbObjectStorageDotNet storage) {
        super("GetStatement");
        fStatement = new IgValue(
                new IgType("System.Data.SqlClient.SqlCommand"), "fStatement");
    }

    public void setupSignature() {
        setReturnType(fStatement.getType());

        getJavaDoc().addLine("Xe[gg (SqlCommand) 擾܂B");
        getJavaDoc().addLine(
                "̃\bhĂяoƂ͐܂BʓI Statement𒼐ڗpKv͂܂B");
        getJavaDoc().addReturn("StatementIuWFNg");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addReturn(fStatement);
    }
}