/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Type;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.IgConstructor;

/**
 * @author Yasuo Nakanishi
 */
public class QueryConstructorDotNet extends IgConstructor {
    private IgValue _connectinonArgument = new IgValue(new IgType(
            "System.Data.SqlClient.SqlConnection"), "connection");

    public QueryConstructorDotNet(final Type type) {
        super(type.getName());
    }

    public void setupSignature() {
        addArgument(_connectinonArgument);

        getJavaDoc().addLine(getName() + "NX̃RXgN^łB");
        getJavaDoc().addLine("ӁFNX𗘗pAŌɕKClose()\bhĂяoKv܂B");
        getJavaDoc().addParameter(_connectinonArgument.getName(), "f[^x[Xڑ");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        final IgValue connectionField = new IgValue(new IgType(
                "System.Data.SqlClient.SqlConnection"), "fConnection");
        implementor.assign(connectionField, _connectinonArgument);
    }
}