/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.field;

import blanco.ig.expander.IgType;
import blanco.ig.expander.Scope;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;

/**
 * QueryNXfLogtB[hłB
 * 
 * @author IGA Tosiki
 */
public class LogFieldDotNet extends FieldExpander {
    /**
     * QueryNXfLogtB[h̃RXgN^łB
     * 
     * @param bindClassName
     *            OIuWFNgƂČт̃NXB
     * @author IGA Tosiki
     */
    public LogFieldDotNet(final String bindClassName) {
        super(new IgType("org.apache.commons.logging.Log"), "fLog");

        getJavaDoc().addLine("̃NXIɗp郍MÔ߂̃IuWFNgIuWFNgB");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("̃IuWFNgoRāÃNX̃MOs܂B");
        setDefaultStatement(new Statement("LogFactory.getLog(" + bindClassName
                + ".class)"));
    }

    /**
     * WFl[VMbvfUCp^[p\ɂȂړIŁAXR[vprotectedƂ܂B
     */
    protected Scope getScope() {
        return Scope.PROTECTED;
    }

    protected boolean isStatic() {
        return true;
    }

    protected boolean isFinal() {
        return true;
    }
}
