/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.definition.QueryInvokerDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Tosiki Iga
 */
public class ExecuteSingleUpdateMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private String runtimePackage = null;

    public ExecuteSingleUpdateMethodDotNet(
            final BlancoDbObjectStorageDotNet storage,
            final QueryInvokerDotNet invoker) {
        super("ExecuteSingleUpdate");
        this.storage = storage;

        runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }
    }

    public void setupSignature() {
        final IgType resultType = new IgType("void");

        setReturnType(resultType);

        final IgType noRowModifiedException = new IgType(runtimePackage
                + ".exception.NoRowModifiedException");
        addUsingType(noRowModifiedException);
        final IgType tooManyRowsModifiedException = new IgType(runtimePackage
                + ".exception.TooManyRowsModifiedException");
        addUsingType(tooManyRowsModifiedException);

        final IgType integrityConstraintException = new IgType(runtimePackage
                + ".exception.IntegrityConstraintException");
        addUsingType(integrityConstraintException);

        getJavaDoc().addLine("s^NGs܂B");
        getJavaDoc().addLine(
                "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B");

        getJavaDoc().addLine("");
        getJavaDoc().addLine("singleL");
        getJavaDoc().addLine("sʂ1ȊȌꍇɂ́ANotSingleRowExceptionNX");
        getJavaDoc().addLine("hNX̗O܂B");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        getData().addLine("int result = 0;");
        getData().addLine("result = ExecuteUpdate();");
        getData().addLine("");
        getData().addLine("if (result == 0) {");
        getData().addLine(
                "throw new NoRowModifiedException(\"sꌏύX܂łB\");");
        getData().addLine("} else if (result > 1) {");
        getData().addLine(
                "String message = \"ꌏ𒴂sύXĂ܂܂Bê:\" + result;");
        getData().addLine("throw new TooManyRowsModifiedException(message);");
        getData().addLine("}");
    }
}