/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.db.definition.QueryInvokerDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.Scope;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author Yasuo Nakanishi
 */
public class ExecuteUpdateMethodDotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private QueryInvokerDotNet fInvoker = null;

    private String runtimePackage = null;

    public ExecuteUpdateMethodDotNet(final BlancoDbObjectStorageDotNet storage,
            final QueryInvokerDotNet invoker) {
        super("ExecuteUpdate");
        this.storage = storage;
        this.fInvoker = invoker;

        runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final IgType blancoDbUtil = new IgType(runtimePackage
                + ".util.BlancoDbUtil");
        addUsingType(blancoDbUtil);
    }

    /**
     * VOLłꍇɂ protectedƂ܂B
     */
    protected Scope getScope() {
        if (fInvoker.isSingle()) {
            return Scope.PROTECTED;
        } else {
            return Scope.PUBLIC;
        }
    }

    public void setupSignature() {
        final IgType resultType = new IgType("int");
        setReturnType(resultType);

        final IgType integrityConstraintException = new IgType(runtimePackage
                + ".exception.IntegrityConstraintException");
        addUsingType(integrityConstraintException);

        getJavaDoc().addLine("s^NGs܂B");
        getJavaDoc().addLine(
                "f[^x[X̐ᔽꍇɂ IntegrityConstraintException O܂B");

        if (fInvoker.isSingle()) {
            getJavaDoc().addLine("");
            getJavaDoc().addLine("VOLȂ̂ŃXR[vprotectedƂ܂B");
            getJavaDoc().addLine(
                    "̃\bh̑ ExecuteSingleUpdate\bh𗘗pĂB");
        }

        getJavaDoc().addReturn("ꂽs");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName() + "\");");
            implementor.addLine("}");
            implementor.addLine("");
        }

        // statementmۂł΂AIprepareStatementĂяo܂B
        implementor.addLine("if (fStatement == null) {");
        implementor
                .addLine("// PreparedStatement擾̏ԂȂ̂ŁAExecuteNonQuery()sɐ旧PrepareStatement()\bhĂяoĎ擾܂B");
        implementor.addStatement("PrepareStatement()");
        implementor.addLine("}");

        implementor.emptyLine();

        // ׂƓWJ܂B
        implementor.addLine("try {");
        implementor.addLine("return fStatement.ExecuteNonQuery();");
        implementor.addLine("} catch (SqlException ex) {");
        implementor.addLine("throw BlancoDbUtil.ConvertToBlancoException(ex);");
        implementor.addLine("}");
    }
}