/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.db.BlancoDbConstantsDotNet;
import blanco.db.BlancoDbMeta2XmlDotNet;
import blanco.db.BlancoDbTableMeta2XmlDotNet;
import blanco.db.BlancoDbXml2CsClassDotNet;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDefDotNet;
import blanco.db.resourcebundle.BlancoDbDotNetResourceBundle;

/**
 * blancoDbDotNetAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoDbDotNetTask extends AbstractBlancoDbDotNetTask {
    /**
     * \[XohANZTIuWFNgL܂B
     */
    private final BlancoDbDotNetResourceBundle fBundle = new BlancoDbDotNetResourceBundle();

    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoDbConstantsDotNet.PRODUCT_NAME + " ("
                + BlancoDbConstantsDotNet.VERSION + ")");

        try {
            final File blancoTmpDbTableDirectory = new File(getTmpdir()
                    + BlancoDbConstantsDotNet.TARGET_SUBDIRECTORY + "/table");
            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + BlancoDbConstantsDotNet.TARGET_SUBDIRECTORY + "/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbDatabaseConnectionSettingDefDotNet connDef = new BlancoDbDatabaseConnectionSettingDefDotNet();
            connDef.setJdbcDriver(getJdbcdriver());
            connDef.setJdbcUrl(getJdbcurl());
            connDef.setJdbcUser(getJdbcuser());
            connDef.setJdbcPassword(getJdbcpassword());

            if (getSchema() != null) {
                // XL[}wB
                connDef.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // SimpleTableGateway
                final BlancoDbTableMeta2XmlDotNet gateway2xml = new BlancoDbTableMeta2XmlDotNet() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                gateway2xml.process(connDef, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2CsClassDotNet generator = new BlancoDbXml2CsClassDotNet() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbTableDirectory,
                        getBasepackage(), getRuntimepackage(),
                        getStatementtimeout(), getTargetdir());
            }

            if (getSql() == null || getSql().equals("true")) {
                final File fileMetadir = new File(getMetadir());
                if (fileMetadir.exists() == false) {
                    throw new IllegalArgumentException(fBundle
                            .getAnttaskErr001(getMetadir()));
                }

                new BlancoDbMeta2XmlDotNet().processDirectory(fileMetadir,
                        blancoTmpDbSqlDirectory.getAbsolutePath());

                // XMLt@CR/O}bsO
                final BlancoDbXml2CsClassDotNet generator = new BlancoDbXml2CsClassDotNet() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    generator.setLogging(true);
                }
                generator.process(connDef, blancoTmpDbSqlDirectory,
                        getBasepackage(), getRuntimepackage(),
                        getStatementtimeout(), getTargetdir());
            }
        } catch (SQLException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr006()
                    + e.toString());
        }
    }
}
