/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

package blanco.db;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.db.collector.BlancoDbCollectorDotNet;
import blanco.db.collector.BlancoDbDatabaseConnectionDotNet;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDefDotNet;
import blanco.db.conf.BlancoDbMetadataDotNet;
import blanco.db.conf.BlancoDbSettingDotNet;
import blanco.db.definition.BlancoDbDefinitionDotNet;
import blanco.db.generator.BlancoDbGeneratorDotNet;

/**
 * blancoDb𗘗pۂ̂Ƃ{IGenerator܂B
 */
public abstract class BlancoDbXml2CsClassDotNet implements
        IBlancoDbProgressDotNet {
    private boolean isLogging = false;

    public void setLogging(final boolean arg) {
        isLogging = arg;
    }

    /**
     * łʓI blancoDbGenerators܂B
     * 
     * @param jdbcDriver
     *            JDBChCoNX
     * @param jdbcUrl
     *            JDBCڑURI
     * @param jdbcUsername
     *            JDBC[U
     * @param jdbcPassword
     *            JDBCpX[h
     * @param blancoSqlDirectory
     *            blancoSqli[ꂽfBNg.nullw̍ۂɂ͏XLbv܂.
     * @param rootPackage
     *            blancoɐݒ肷郋[gpbP[W
     * @param statementTimeout
     *            Xe[gg^CAEglB
     * @return IȂtrue, ُIȂfalse
     * @throws BlancoDbException
     * @throws ParserConfigurationException
     * @throws IOException
     * @throws SAXException
     * @throws SQLException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    public void process(
            final BlancoDbDatabaseConnectionSettingDefDotNet connDef,
            final File blancoSqlDirectory, final String rootPackage,
            String runtimePackage, final String statementTimeout,
            final String blancoTargetSourceDirectory) throws SQLException,
            SAXException, IOException, ParserConfigurationException,
            ClassNotFoundException, TransformerException {
        System.out.println(BlancoDbConstantsDotNet.PRODUCT_NAME + " ("
                + BlancoDbConstantsDotNet.VERSION + ") \[XR[h: Jn.");

        final BlancoDbSettingDotNet setting = new BlancoDbSettingDotNet();
        setting.setJdbc(connDef);
        setting.setLogging(isLogging);
        if (blancoTargetSourceDirectory != null) {
            setting.setWorkDirectory(blancoTargetSourceDirectory);
        }
        if (BlancoStringUtil.null2Blank(runtimePackage).length() > 0) {
            setting.setRuntimePackage(runtimePackage);
        }

        if (BlancoStringUtil.null2Blank(statementTimeout).length() > 0) {
            try {
                setting.setStatementTimeout(Integer.parseInt(statementTimeout));
            } catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Xe[gg^CAEglƂĎw肳ꂽl["
                        + statementTimeout + "]͐lƂĉ͂ł܂łBf܂B:"
                        + ex.toString());
            }
        }

        final BlancoDbDatabaseConnectionDotNet dbInfoCollector = new BlancoDbDatabaseConnectionDotNet();
        try {
            dbInfoCollector.connect(connDef);
            dbInfoCollector.getDatabaseVersionInfo();
            setting.setDriverName(dbInfoCollector.getDriverName());

            setting.setRootNameSpace(rootPackage);

            if (blancoSqlDirectory != null) {
                // w肪ꍇɂ̂ SQL`t@Ci[fBNg܂B

                // ValueObjecti[fBNg쐬܂B
                new File(blancoSqlDirectory.getAbsolutePath() + "/valueobject")
                        .mkdirs();

                final File[] fileSettingXml = blancoSqlDirectory.listFiles();
                for (int index = 0; index < fileSettingXml.length; index++) {
                    if (fileSettingXml[index].getName().endsWith(".xml") == false) {
                        // t@C̊gq xml ł̂̂ݏ܂B
                        continue;
                    }
                    if (progress(index + 1, fileSettingXml.length,
                            fileSettingXml[index].getName()) == false) {
                        break;
                    }

                    // ^͖ j܂B
                    BlancoDbMetadataDotNet metadata = new BlancoDbMetadataDotNet();
                    parseAndProcessBlancoDbSettingFile(fileSettingXml[index],
                            metadata);

                    // ̓t@Cɍs܂B
                    generate(metadata, setting, dbInfoCollector, rootPackage,
                            new File(blancoSqlDirectory.getAbsolutePath()
                                    + "/valueobject"));
                }
            }

        } finally {
            dbInfoCollector.close();
            System.out.println("\[XR[h: I.");
        }
    }

    /**
     * s܂B
     * 
     * @param metadata
     * @param setting
     * @param conn
     * @param rootPackage
     * @param outputDirectory
     * @throws SQLException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws BlancoDbException
     * @throws TransformerException
     */
    private void generate(final BlancoDbMetadataDotNet metadata,
            final BlancoDbSettingDotNet setting,
            final BlancoDbDatabaseConnectionDotNet conn,
            final String rootPackage, final File outputDirectory)
            throws SQLException, SAXException, IOException,
            ParserConfigurationException, TransformerException {
        final BlancoDbCollectorDotNet collector = new BlancoDbCollectorDotNet();
        final BlancoDbDefinitionDotNet definition = collector.collect(metadata,
                conn);

        final BlancoDbGeneratorDotNet generator = new BlancoDbGeneratorDotNet(
                setting);
        generator.setup(definition, rootPackage, outputDirectory);
        generator.generate();
    }

    /**
     * BlancoDb SQL`t@Cp[XāAKv΃^ɒǉ܂B ̃\bh OĂяoꍇ܂B
     * 
     * @param fileSettingXml
     *            ͂ƂȂblancoDbݒt@C
     * @param metadata
     *            o͂ƂȂ郁^f[^
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws SAXException
     */
    private void parseAndProcessBlancoDbSettingFile(final File fileSettingXml,
            final BlancoDbMetadataDotNet metadata) throws IOException,
            ParserConfigurationException, SAXException {
        System.out.println("t@C[" + fileSettingXml.getAbsolutePath()
                + "]܂");

        final DocumentBuilderFactory documentFactory = DocumentBuilderFactory
                .newInstance();
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = documentFactory.newDocumentBuilder();
        } catch (ParserConfigurationException ex1) {
            System.err.println("hLg쐬ɗO܂.:" + ex1.toString());
            ex1.printStackTrace();
            throw ex1;
        }
        try {
            document = documentBuilder.parse(fileSettingXml);
        } catch (SAXException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            throw e;
        } catch (IOException e) {
            System.err.println("hLgp[XɗO܂:" + e.toString());
            e.printStackTrace();
            throw e;
        }
        final Element blancoDbElement = document.getDocumentElement();
        if (blancoDbElement == null) {
            System.out.println("blanco-db[gm[h܂");
            return;
        }
        final NodeList rootNodeList = blancoDbElement.getChildNodes();
        if (rootNodeList == null) {
            return;
        }
        metadata.addXml(fileSettingXml);
    }
}