/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Yasuo Nakanishi
 */
public class BlancoDbMetadataDotNet {
    private String _name = "";

    private String _middleNameSpace = "";

    private File fileXml = null;

    private final List _tableList = new ArrayList();

    public BlancoDbMetadataDotNet() {
    }

    public BlancoDbMetadataDotNet(final String name) {
        _name = name;
    }

    public BlancoDbMetadataDotNet(final String name,
            final String middleNameSpace) {
        _name = name;
        _middleNameSpace = middleNameSpace;
    }

    public String getName() {
        return _name;
    }

    public int getTableCount() {
        return _tableList.size();
    }

    public TableDotNet getTable(final int index) {
        return (TableDotNet) _tableList.get(index);
    }

    public void addTable(final TableDotNet table) {
        _tableList.add(table);
    }

    public void addXml(final File fileXml) {
        this.fileXml = fileXml;
    }

    public File getXml() {
        return fileXml;
    }

    public String getMiddleNamespace() {
        return _middleNameSpace;
    }
}