/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import blanco.ig.expander.IgType;

/**
 * @author Yasuo Nakanishi
 */
public class QueryFieldDotNet extends AbstractFieldDotNet {
    private boolean _isReadOnly = false;

    private boolean _isWritable = false;

    private boolean _isDefinitelyWritable = false;

    public QueryFieldDotNet(final IgType type, final String name) {
        super(type, name);
    }

    /**
     * @return _isDefinitelyWritable ߂܂B
     */
    public boolean getDefinitelyWritable() {
        return _isDefinitelyWritable;
    }

    /**
     * @param definitelyWritable
     *            _isDefinitelyWritable ݒB
     */
    public void setDefinitelyWritable(final boolean definitelyWritable) {
        _isDefinitelyWritable = definitelyWritable;
    }

    /**
     * @return _isReadOnly ߂܂B
     */
    public boolean getReadOnly() {
        return _isReadOnly;
    }

    /**
     * @param readOnly
     *            _isReadOnly ݒB
     */
    public void setReadOnly(final boolean readOnly) {
        _isReadOnly = readOnly;
    }

    /**
     * @author Tosiki Iga
     * @since 2005.05.01
     */
    public boolean getWritable() {
        return _isWritable;
    }

    /**
     * @author Tosiki Iga
     * @since 2005.05.01
     */
    public void setWritable(final boolean isWritable) {
        _isWritable = isWritable;
    }
}
