/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.exception;

import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.implementor.Statement;
import blanco.ig.expander.method.Constructor;

/**
 * f[^x[XᔽɊւONX <br>
 * ̃NXNXblancoDb\[XR[hŗp܂ <br>
 * 
 * @since 2005.05.12
 * @author IGA Tosiki
 */
public class TimeoutExceptionClassDotNet extends ClassExpander {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "TimeoutException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "f[^x[X̃^CAEgƂOIuWFNg ̃CX^X쐬܂B";

    public TimeoutExceptionClassDotNet(final Type argType) {
        super(argType);
    }

    protected void expandClassStruct() {
        setSuperClass(new Type("System.Exception"));

        getJavaDoc().addLine("f[^x[X^CAEgɊւONXB");
        getJavaDoc().addLine("̃NXblancoDb\[XR[hŗp܂B");
        getJavaDoc().addLine("̃NX́A\[XR[h̃t@CƂėp܂B");
        getJavaDoc().addLine("");
        getJavaDoc().addLine("@since 2006.06.30");
        getJavaDoc().addLine("@author blanco Framework");

        final FieldExpander fieldCode = new FieldExpander(new Type("string"),
                "SQLSTATE_TIMEOUT") {
            protected Scope getScope() {
                return Scope.PROTECTED;
            }

            protected boolean isStatic() {
                return true;
            }

            protected boolean isFinal() {
                return true;
            }
        };
        fieldCode.getJavaDoc().addLine("̃NX\SQLStateR[hB");
        fieldCode.getJavaDoc().addLine(
                "vO SQLStateɗ炸 ONXɂĔf悤ɂĂB");
        fieldCode.setDefaultStatement(new Statement("\"HYT00\""));
        addField(fieldCode);

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getCgMethod()
                        .setSuperclassInvocation(
                                "base(\"Timeout exception has occured.\" + SQLSTATE_TIMEOUT)");
            }

            public void implement() {
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("string"), "reason"));
                getCgMethod().setSuperclassInvocation(
                        "base(reason + SQLSTATE_TIMEOUT)");
            }

            public void implement() {
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("string"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("string"), "SQLState"));
                getCgMethod()
                        .setSuperclassInvocation("base(reason + SQLState)");
            }

            public void implement() {
            }
        });

        addMethod(new Constructor(CLASS_NAME) {
            public void setupSignature() {
                getJavaDoc().addLine(CONSTRUCTOR_JAVADOC);
                getJavaDoc().addParameter("reason", "O̐");
                addArgument(new Value(new Type("string"), "reason"));
                getJavaDoc().addParameter("SQLState",
                        "Oʂ XOPENR[h܂ SQL 99̃R[h");
                addArgument(new Value(new Type("string"), "SQLState"));
                getJavaDoc().addParameter("vendorCode",
                        "f[^x[Xx_[߂ŗL̗OR[h");
                addArgument(new Value(new Type("int"), "vendorCode"));
                getCgMethod().setSuperclassInvocation(
                        "base(reason + SQLState + vendorCode)");
            }

            public void implement() {
            }
        });
    }
}