/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.definition;

import java.util.Iterator;

import blanco.db.conf.CallQueryDotNet;

/**
 * @author Yasuo Nakanishi
 */
public class QueryCallerDotNet {

    private CallQueryDotNet _callQuery = null;

    public QueryCallerDotNet(final CallQueryDotNet callQuery) {
        _callQuery = callQuery;
    }

    public int getFieldCount() {
        return _callQuery.getInParameterList().size();
    }

    public QueryFieldDotNet getField(final int index) {
        return (QueryFieldDotNet) _callQuery.getInParameterList().get(index);
    }

    public Iterator getFieldIterator() {
        return _callQuery.getFieldIterator();
    }

    public String getName() {
        return _callQuery.getName();
    }

    public Iterator getInParameterIterator() {
        return _callQuery.getInParameterIterator();
    }

    public Iterator getOutParameterIterator() {
        return _callQuery.getOutParameterIterator();
    }

    public String getQuery() {
        return _callQuery.getQuery();
    }

    public void setQuery(final String query) {
        _callQuery.setQuery(query);
    }

    public boolean isSingle() {
        return _callQuery.isSingle();
    }
}