/*
 * blancoDb
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util.method;

import blanco.db.collector.BlancoDbDatabaseConnectionDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.Value;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class ConvertToBlancoExceptionMethodDotNet extends MethodExpander {
    private static final boolean IS_DEBUG = false;

    protected Scope getScope() {
        return Scope.PUBLIC;
    }

    protected boolean isStatic() {
        return true;
    }

    public ConvertToBlancoExceptionMethodDotNet(
            final BlancoDbObjectStorageDotNet storage) {
        super("ConvertToBlancoException");

        // ^CpbP[W̕ωɑΉB
        String runtimePackage = storage.getSetting().getRootNameSpace();
        if (storage.getSetting().getRuntimePackage() != null) {
            runtimePackage = storage.getSetting().getRuntimePackage();
        }

        final Type integrityConstraintException = new Type(runtimePackage
                + ".exception.IntegrityConstraintException");
        addUsingType(integrityConstraintException);

        final Type deadlockException = new Type(runtimePackage
                + ".exception.DeadlockException");
        addUsingType(deadlockException);

        final Type timeoutException = new Type(runtimePackage
                + ".exception.TimeoutException");
        addUsingType(timeoutException);

        addUsingType(new Type("System.Data.SqlClient.SqlException"));

        if (BlancoDbDatabaseConnectionDotNet.DRIVERNAME_SQLSERVER_2000
                .equals(storage.getSetting().getDriverName())
                || BlancoDbDatabaseConnectionDotNet.DRIVERNAME_SQLSERVER_2005
                        .equals(storage.getSetting().getDriverName())) {
            if (IS_DEBUG) {
                System.out.println("TRACE: SQL ServerłB");
            }
        } else {
            if (IS_DEBUG) {
                System.out.println("TRACE: SQL ServerłBhCo["
                        + storage.getSetting().getDriverName() + "]");
            }
        }
    }

    public void setupSignature() {
        getJavaDoc().addLine(
                "SQLO̓e`FbNAKvɉblanco FrameworkOIuWFNgɕϊăX[܂B");
        getJavaDoc().addLine("");
        getJavaDoc()
                .addLine(
                        "SQLÔȂŁAblanco Framework̗OIuWFNgɕϊׂ̂ɂIntegrityConstraintException, DeadlockException, TimeoutExceptionɕϊ̏ throw ܂B");
        getJavaDoc().addLine("ϊׂ悪ꍇɂ́Â܂܌̃IuWFNgԋp܂B");
        getJavaDoc().addParameter("ex", "ADO.NETԋpꂽOIuWFNgB");
        addArgument(new Value(new Type("System.Data.SqlClient.SqlException"),
                "ex"));
        getJavaDoc()
                .addReturn("ƂSQLOIuWFNgB܂œBꍇɂ́Aϊ̕KvƂ܂B");
        setReturnType(new Type("System.Data.SqlClient.SqlException"));
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        implementor.addLine("if (ex.Number == 2627) {");
        implementor
                .addLine("IntegrityConstraintException exBlanco = new IntegrityConstraintException(\"f[^x[XᔽɂύXs܂B\" + ex.ToString() + \"ANumber=\" + ex.Number);");

        implementor.addLine("throw exBlanco;");
        implementor.addLine("} else if (ex.Number == 1205) {");
        implementor
                .addLine("// fbhbNSQLServermۂɔOBftHgł́AfbhbNm5bB");
        implementor
                .addLine("DeadlockException exBlanco = new DeadlockException(\"f[^x[XfbhbNɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number);");
        implementor.addLine("throw exBlanco;");
        implementor.addLine("} else if (ex.Number == 1222) {");
        implementor
                .addLine("// bN҂bN^CAEg̎ԂzĔꍇ̃^CAEgBftHg̓^CAEgȂB");
        implementor
                .addLine("TimeoutException exBlanco = new TimeoutException(\"f[^x[XbN҂̃^CAEgɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number);");
        implementor.addLine("throw exBlanco;");
        implementor.addLine("} else if (ex.Number == -2) {");
        implementor
                .addLine("// R}h̃^CAEgBSqlCommand.CommandTimeoutɂĐݒBftHg30bB");
        implementor
                .addLine("TimeoutException exBlanco = new TimeoutException(\"R}h^CAEgɂf[^x[X삪s܂B\" + ex.ToString() + \"ANumber=\" + ex.Number);");
        implementor.addLine("throw exBlanco;");
        implementor.addLine("}");
        implementor.addLine("return ex;");
    }
}