/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringgroup;

import java.io.File;
import java.io.IOException;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.stringgroup.resourcebundle.BlancoStringGroupResourceBundle;
import blanco.stringgroup.valueobject.BlancoStringGroupFieldStructure;
import blanco.stringgroup.valueobject.BlancoStringGroupStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * uO[v`vExcell當O[vNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringGroupXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoStringGroupResourceBundle fBundle = new BlancoStringGroupResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private String fTargetLang = null;

    /**
     * Iɗpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * Iɗp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۂƂȂvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final File argDirectoryTarget)
            throws IOException {

        fTargetLang = argTargetLang;

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // ꗗ擾܂B
            final BlancoXmlElement elementList = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle.getMeta2xmlElementList());

            // V[gڍׂȏ擾܂B
            final BlancoStringGroupStructure processStructure = parseSheet(
                    elementCommon, elementList, argDirectoryTarget);

            if (processStructure != null) {
                // ^̉͌ʂƂɃ\[XR[hs܂B
                expandSourceFile(processStructure, argDirectoryTarget);
            }
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param argElementList
     *            ݏĂListm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoStringGroupStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final BlancoXmlElement argElementList, final File argDirectoryTarget) {

        final BlancoStringGroupStructure processStructure = new BlancoStringGroupStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (argElementList == null) {
            return null;
        }

        // ꗗ̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                argElementList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);

            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;
            BlancoStringGroupFieldStructure field = new BlancoStringGroupFieldStructure();
            field
                    .setNo(BlancoXmlBindingUtil.getTextContent(elementField,
                            "no"));

            field.setValue(BlancoXmlBindingUtil.getTextContent(elementField,
                    "value"));
            if (BlancoStringUtil.null2Blank(field.getValue()).length() == 0) {
                continue;
            }

            field.setConstant(BlancoXmlBindingUtil.getTextContent(elementField,
                    "constant"));

            field.setDescription(BlancoXmlBindingUtil.getTextContent(
                    elementField, "description"));

            // ɓeo^ĂȂǂ̃`FbNB
            for (int indexPast = 0; indexPast < processStructure.getListField()
                    .size(); indexPast++) {
                final BlancoStringGroupFieldStructure fieldPast = (BlancoStringGroupFieldStructure) processStructure
                        .getListField().get(indexPast);
                if (fieldPast.getValue().equals(field.getValue())) {
                    throw new IllegalArgumentException(fBundle
                            .getXml2sourceFileErr003(
                                    processStructure.getName(), field
                                            .getValue()));
                }
            }

            processStructure.getListField().add(field);
        }

        return processStructure;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    private void expandSourceFile(
            final BlancoStringGroupStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName()
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argProcessStructure
                        .getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        expandField(argProcessStructure);
        expandMethodMatch(argProcessStructure);

        if ("java".equals(fTargetLang) || "cs".equals(fTargetLang)) {
            expandMethodMatchIgnoreCase(argProcessStructure);
        }

        expandMethodConvertToInt(argProcessStructure);

        if ("java".equals(fTargetLang)) {
            BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                    fCgSourceFile, fileBlancoMain);
        } else if ("cs".equals(fTargetLang)) {
            BlancoCgTransformerFactory.getCsSourceTransformer().transform(
                    fCgSourceFile, fileBlancoMain);
        } else if ("js".equals(fTargetLang)) {
            BlancoCgTransformerFactory.getJsSourceTransformer().transform(
                    fCgSourceFile, fileBlancoMain);
        } else {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(fTargetLang));
        }
    }

    /**
     * 萔tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandField(
            final BlancoStringGroupStructure argProcessStructure) {

        boolean isProcessed = false;
        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getListField().get(indexField);
            if (BlancoStringUtil.null2Blank(fieldLook.getConstant()).length() == 0) {
                continue;
            }

            String description = "";
            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                description += fBundle.getXml2sourceFileFieldNo(fieldLook
                        .getNo()
                        + " ");
            }
            if (fieldLook.getDescription() != null) {
                description += fBundle.getXml2sourceFileDescription(fieldLook
                        .getDescription());
            }

            final BlancoCgField cgField = fCgFactory.createField(fieldLook
                    .getConstant().toUpperCase(), "int", description);
            fCgClass.getFieldList().add(cgField);

            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault(Integer.toString(indexField + 1));
            isProcessed = true;
        }

        if (isProcessed) {
            final BlancoCgField cgField = fCgFactory.createField("NOT_DEFINED",
                    "int", "`BO[vȊO̕܂͒萔`̂́B");
            fCgClass.getFieldList().add(cgField);

            cgField.setAccess("public");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault("-1");
        }
    }

    /**
     * match\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatch(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("match"), "O[vɊ܂܂镶ł邩ǂ𔻒肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB"));

        final List lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getListField().get(indexField);

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo())));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription())));
            }

            if ("java".equals(fTargetLang) || "cs".equals(fTargetLang)) {
                lineList.add(fCgFactory.createLine("if (\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(fieldLook.getValue())
                        + "\"." + getMethodName("equals") + "(argCheck)) {"));
            } else if ("js".equals(fTargetLang)) {
                lineList.add(fCgFactory.createLine("if (\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(fieldLook.getValue())
                        + "\" == argCheck) {"));
            }

            lineList.add(fCgFactory.createLine("return true;"));
            lineList.add(fCgFactory.createLine("}"));
        }
        lineList.add(fCgFactory.createLine("return false;"));
    }

    /**
     * matchIgnoreCase\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodMatchIgnoreCase(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("matchIgnoreCase"),
                "O[vɊ܂܂镶ł邩ǂA啶ʂ肵܂B");
        fCgClass.getMethodList().add(cgMethod);
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "`FbNsB"));
        cgMethod.setReturn(fCgFactory.createReturn(getTypeBoolean(),
                "O[vɊ܂܂ĂtureBO[vɊ܂܂ȂłfalseB"));

        final List lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getListField().get(indexField);

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo())));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription())));
            }

            if ("java".equals(fTargetLang)) {
                lineList.add(fCgFactory.createLine("if (\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(fieldLook.getValue())
                        + "\"." + getMethodName("equalsIgnoreCase")
                        + "(argCheck)) {"));
            } else if ("cs".equals(fTargetLang)) {
                lineList
                        .add(fCgFactory
                                .createLine("if (\""
                                        + BlancoJavaSourceUtil
                                                .escapeStringAsJavaSource(fieldLook
                                                        .getValue())
                                        + "\"."
                                        + getMethodName("equals")
                                        + "(argCheck, StringComparison.CurrentCultureIgnoreCase)) {"));
                fCgSourceFile.getImportList().add("System.StringComparison");
            } else if ("js".equals(fTargetLang)) {
                // ݁AΉĂ܂B
            }

            lineList.add(fCgFactory.createLine("return true;"));
            lineList.add(fCgFactory.createLine("}"));
        }
        lineList.add(fCgFactory.createLine("return false;"));
    }

    /**
     * convertToInt\bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodConvertToInt(
            final BlancoStringGroupStructure argProcessStructure) {

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName("convertToInt"), "񂩂萔ɕϊ܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getLangDoc().getDescriptionList().add(
                "萔`̏ꍇ ^ꂽ񂪕O[vȌꍇɂ NOT_DEFINED ߂܂B");
        cgMethod.getParameterList().add(
                fCgFactory.createParameter("argCheck", getTypeString(),
                        "ϊsB"));
        cgMethod.setReturn(fCgFactory.createReturn("int", "萔ɕϊ̒lB"));

        final List lineList = cgMethod.getLineList();

        for (int indexField = 0; indexField < argProcessStructure
                .getListField().size(); indexField++) {
            final BlancoStringGroupFieldStructure fieldLook = (BlancoStringGroupFieldStructure) argProcessStructure
                    .getListField().get(indexField);

            if (BlancoStringUtil.null2Blank(fieldLook.getConstant()).length() == 0) {
                // 萔`̂̂̓XLbv܂B
                continue;
            }

            // ʂ̕ɑ΂鏈Lq܂B
            if (fieldLook.getNo() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileFieldNo(fieldLook.getNo())));
            }
            if (fieldLook.getDescription() != null) {
                lineList.add(fCgFactory.createLine("// "
                        + fBundle.getXml2sourceFileDescription(fieldLook
                                .getDescription())));
            }

            if ("java".equals(fTargetLang) || "cs".equals(fTargetLang)) {
                lineList.add(fCgFactory.createLine("if (\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(fieldLook.getValue())
                        + "\"." + getMethodName("equals") + "(argCheck)) {"));
            } else if ("js".equals(fTargetLang)) {
                lineList.add(fCgFactory.createLine("if (\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(fieldLook.getValue())
                        + "\" == argCheck) {"));
            }
            lineList.add(fCgFactory.createLine("return "
                    + fieldLook.getConstant().toUpperCase() + ";"));
            lineList.add(fCgFactory.createLine("}"));
        }

        lineList.add(fCgFactory.createLine(""));
        lineList.add(fCgFactory.createLine("// Y萔܂łB"));
        lineList.add(fCgFactory.createLine("return NOT_DEFINED;"));
    }

    /**
     * vO~Oꏈnɍ boolean ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeBoolean() {
        if ("java".equals(fTargetLang)) {
            return "boolean";
        } else if ("cs".equals(fTargetLang)) {
            return "bool";
        } else if ("js".equals(fTargetLang)) {
            return "boolean";
        } else {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(fTargetLang));
        }
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        if ("java".equals(fTargetLang)) {
            return "java.lang.String";
        } else if ("cs".equals(fTargetLang)) {
            return "string";
        } else if ("js".equals(fTargetLang)) {
            return "string";
        } else {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(fTargetLang));
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @param argMethodName
     *            \bhB
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        if ("java".equals(fTargetLang)) {
            return argMethodName;
        } else if ("cs".equals(fTargetLang)) {
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        } else if ("js".equals(fTargetLang)) {
            return argMethodName;
        } else {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(fTargetLang));
        }
    }
}
