/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.collector;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;

import blanco.db.conf.BlancoDbDatabaseConnectionSettingDefDotNet;

/**
 * BlancoDbf[^x[Xڑێ܂B <br>
 * f[^x[X̊e擾܂B
 * 
 * @since 2005.05.12
 * @author iga
 */
public class BlancoDbDatabaseConnectionDotNet {
    /**
     * SQL Server 2000pJDBChCo
     */
    public static final String DRIVERNAME_SQLSERVER_2000 = "SQLServer";

    /**
     * SQL Server 2005pJDBChCo
     */
    public static final String DRIVERNAME_SQLSERVER_2005 = "Microsoft SQL Server 2005 JDBC Driver";

    public static final String DRIVERNAME_ORACLE = "Oracle JDBC driver";

    public static final String DRIVERNAME_POSTGRESQL = "PostgreSQL Native Driver";

    private Connection _conn = null;

    private String _driverName = null;

    private String _driverVersion = null;

    public String getDriverName() {
        return _driverName;
    }

    public String getDriverVersion() {
        return _driverVersion;
    }

    /**
     * f[^x[Xڑ̊m݂܂B
     * 
     * @param connDef
     * @throws SQLException
     * @throws ClassNotFoundException
     */
    public void connect(final BlancoDbDatabaseConnectionSettingDefDotNet connDef)
            throws SQLException, ClassNotFoundException {
        System.out.println("f[^x[XڑI[v܂.");
        try {
            System.out.println("  Driver:" + connDef.getJdbcDriver());
            Class.forName(connDef.getJdbcDriver());
        } catch (ClassNotFoundException ex) {
            System.out.println("JDBChCõ[hɎs܂: " + ex.toString());
            throw ex;
        }
        try {
            System.out.println("  URL:" + connDef.getJdbcUrl());
            System.out.println("  User:" + connDef.getJdbcUser());
            _conn = DriverManager.getConnection(connDef.getJdbcUrl(), connDef
                    .getJdbcUser(), connDef.getJdbcPassword());

            // R~bgOFFɐݒ肵܂B
            _conn.setAutoCommit(false);
        } catch (SQLException ex) {
            System.out.println("JDBCڑ̊mɎs܂: " + ex.toString());
            throw ex;
        }
    }

    public void close() {
        if (_conn != null) {
            try {
                System.out.println("f[^x[XڑN[Y܂. (rollbackclose܂)");
                try {
                    _conn.rollback();
                } finally {
                    _conn.close();
                }
            } catch (SQLException e) {
                System.out.println("JDBCڑ̊JɎs܂: " + e.toString());
                e.printStackTrace();
            }
            _conn = null;
        }
    }

    public Connection getConnection() {
        return _conn;
    }

    /**
     * f[^x[X̃o[WȂǂ擾܂B
     */
    public void getDatabaseVersionInfo() {
        System.out.println("JDBChCo̊b擾܂B");
        try {
            final DatabaseMetaData databaseMetaData = _conn.getMetaData();

            _driverName = databaseMetaData.getDriverName();
            _driverVersion = databaseMetaData.getDriverVersion();
            System.out.println("  DriverName:" + _driverName);
            System.out.println("  DriverVersion:" + _driverVersion);

            try {
                System.out.println("  DatabaseMajorVersion:"
                        + databaseMetaData.getDatabaseMajorVersion());
                System.out.println("  DatabaseMinorVersion:"
                        + databaseMetaData.getDatabaseMinorVersion());
            } catch (java.lang.AbstractMethodError er) {
                // SQL Server 2000 JDBC Driver ̃\bhT|[g܂B
                // System.out.println(er.toString());
            } catch (SQLException ex) {
            }
            try {
                System.out.println("  JDBCMajorVersion:"
                        + databaseMetaData.getJDBCMajorVersion());
                System.out.println("  JDBCMinorVersion:"
                        + databaseMetaData.getJDBCMinorVersion());
            } catch (java.lang.AbstractMethodError er) {
                // SQL Server 2000 JDBC Driver ̃\bhT|[g܂B
                // System.out.println(er.toString());
            } catch (SQLException ex) {
                // Oracle 9i JDBC Driver ̃\bhT|[g܂B
            }

            if (DRIVERNAME_SQLSERVER_2000.equals(_driverName)) {
                // ̃hCo͒mĂ܂.
            } else if (DRIVERNAME_SQLSERVER_2005.equals(_driverName)) {
                // ̃hCo͒mĂ܂.
            } else if (DRIVERNAME_ORACLE.equals(_driverName)) {
                // ̃hCo͒mĂ܂.
            } else if (DRIVERNAME_POSTGRESQL.equals(_driverName)) {
                // ̃hCo͒mĂ܂.
            } else {
                System.out.println("mJDBChCoł: " + _driverName);
            }

        } catch (SQLException e1) {
            e1.printStackTrace();
            return;
        }
    }
}