/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import blanco.db.definition.QueryIteratorDotNet;
import blanco.db.util.BlancoDbObjectStorageDotNet;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.implementor.Implementor;
import blanco.ig.expander.method.MethodExpander;

/**
 * @author tosiki iga
 */
public class PrepareStatementMethod2DotNet extends MethodExpander {
    private BlancoDbObjectStorageDotNet storage = null;

    private IgValue queryArgument = new IgValue(new IgType("string"), "query");

    private QueryIteratorDotNet _iterator = null;

    public PrepareStatementMethod2DotNet(
            final BlancoDbObjectStorageDotNet storage,
            final QueryIteratorDotNet iterator) {
        super("PrepareStatement");
        this.storage = storage;
        _iterator = iterator;
    }

    public void setupSignature() {
        // ǉĂ݂B
        addArgument(queryArgument);

        getJavaDoc().addLine("NG̃vRpC{܂B");
        getJavaDoc().addLine("Iɓeω悤SQLsKvꍇɂ̂݁Ã\bh𗘗p܂B");
        getJavaDoc()
                .addLine(
                        "SQL̂̂p[^Ƃė^邱ƂłĎRxASQLCWFNVƌĂ΂ZLeBz[댯_ɒӂŗpĂB");
        getJavaDoc().addLine("Iɂ SqlCommand̃RXgN^ Ăяo܂B");
        getJavaDoc().addParameter("query", "pNG(SQL)");
    }

    public void implement() {
        final Implementor implementor = new Implementor(getData());

        if (storage.getSetting().isLogging()) {
            implementor.addLine("if (fLog.isDebugEnabled()) {");
            implementor.addLine("fLog.debug(\"" + getName()
                    + ": query = \" + query);");
            implementor.addLine("}");
            implementor.addLine("");
        }

        implementor.addLine("Close();");

        implementor.addLine("fStatement = new SqlCommand();");
        implementor.addLine("fStatement.Connection = fConnection;");
        implementor.addLine("fStatement.Transaction = fTransaction;");
        implementor.addLine("fStatement.CommandText = query;");

        if (storage.getSetting().getStatementTimeout() >= 0) {
            implementor.addLine("// Xe[gg^CAEglɂăftHglZbg܂B");
            implementor.addLine("fStatement.CommandTimeout = "
                    + storage.getSetting().getStatementTimeout() + ";");
        }
    }
}