/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.util;

/**
 * blanco FrameworkɂAɊւ郆[eBeB܂܂܂B
 * 
 * ƂĂقƂǂ̃\bhstatic\bhƂĒ񋟂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringUtil {
    /**
     * ^ꂽbytez16i\L擾܂BŖ߂܂B
     * 
     * @param arg
     *            ͂ƂȂoCgzB
     * @return 16i\L̕B
     */
    public static final String toHexString(final byte[] arg) {
        final StringBuffer buf = new StringBuffer();
        for (int index = 0; index < arg.length; index++) {
            buf.append(toHexString(arg[index]));
        }
        return buf.toString();
    }

    /**
     * ^ꂽbyte16i\L擾܂BŖ߂܂B
     * 
     * @param arg
     *            oCgB
     * @return 16i\L̕B
     */
    public static final String toHexString(final byte arg) {
        // ̒lɂ16i\L擾܂B
        String strResult = Integer.toHexString(arg & 0xff);
        for (; strResult.length() < 2;) {
            strResult = "0" + strResult;
        }
        return strResult;
    }

    /**
     * ^ꂽchar16i\Lɕϊ܂BŖ߂܂B
     * 
     * @param arg
     *            B
     * @return 16i\L̕B
     */
    public static final String toHexString(final char arg) {
        String strResult = Integer.toHexString(arg);
        for (; strResult.length() < 4;) {
            strResult = "0" + strResult;
        }
        return strResult;
    }

    /**
     * K\Ƃ͊֌WȂ̒us܂B
     * 
     * ̃\bhł java.lang.StringƂ͈قȂ萳K\͊֗^܂B<br>
     * K\@\ĂقȂu̍ۂɗp܂B
     * 
     * @param source
     *            ϊO̕B
     * @param replaceFrom
     *            uB
     * @param replaceTo
     *            u敶B
     * @return ϊ̕B
     */
    public static final String replaceAll(final String source,
            final char replaceFrom, final char replaceTo) {
        return BlancoStringUtilReplace.replaceAll(source, replaceFrom,
                replaceTo);
    }

    /**
     * K\Ƃ͊֌WȂ̒us܂B
     * 
     * ̃\bhł java.lang.StringƂ͈قȂ萳K\͊֗^܂B<br>
     * K\@\ĂقȂu̍ۂɗp܂B
     * 
     * @param source
     *            ϊO̕B
     * @param replaceFrom
     *            uB
     * @param replaceTo
     *            u敶B
     * @return ϊ̕B
     */
    public static final String replaceAll(final String source,
            final String replaceFrom, final String replaceTo) {
        return BlancoStringUtilReplace.replaceAll(source, replaceFrom,
                replaceTo);
    }

    /**
     * ^ꂽnull̏ꍇɁA0̕ւƕϊ܂BŖꍇɂ́Â܂܂̕񂪖߂܂B
     * 
     * null𒷂0̕ɒuꍇɁÃ\bh𗘗p܂B<br>
     * 񏈗̉ߒ null肤̂ ͒0̕Ƃ݂Ȃꍇɂ̃\bh𗘗p邱Ƃz肵܂B
     * 
     * @param originalString
     *            ͕Bnull^ 0̕ɕϊ܂B
     * @return ϊ̕BK nullȊO߂܂B
     */
    public static final String null2Blank(final String originalString) {
        if (originalString == null) {
            // null̏ꍇɂ́A0̕ɒu܂B
            return "";
        }
        // łȂꍇɂ́AƂ̕񂪂̂܂ܖ߂܂B
        return originalString;
    }

    /**
     * ̒擾܂Bnull̏ꍇɂ 0Ƃ݂Ȃ܂B
     * 
     * null肤镶̒擾ꍇɗp邱Ƃz肵Ă܂B
     * 
     * @deprecated ̊mۂ̂߂ɁAnull2Blanklength()𒼐ڌĂяoƂ߂܂B
     * @param sourceString
     *            擾B
     * @return ̒Bnull^ꂽꍇɂ0߂܂B
     */
    public static final int getLengthNullable(final String sourceString) {
        // null^Ă0łƔf܂B
        return null2Blank(sourceString).length();
    }

    /**
     * ^ꂽɂāAɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trimLeft(final String originalString) {
        return BlancoStringUtilTrim.trimLeft(originalString);
    }

    /**
     * ^ꂽɂāAEɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trimRight(final String originalString) {
        return BlancoStringUtilTrim.trimRight(originalString);
    }

    /**
     * ^ꂽɂāAEэɔp󔒂 ܂B
     * 
     * p󔒂̂ݏ܂BSp󔒂͏܂B
     * 
     * @param originalString
     *            sB
     * @return p󔒂؂l߂ꂽ̕B
     */
    public static final String trim(final String originalString) {
        return BlancoStringUtilTrim.trim(originalString);
    }

    /**
     * w̒ɂȂ܂ŁẢEɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padRight(final String argSource,
            final int argLength, final char argPadChar) {
        return BlancoStringUtilPad.padRight(argSource, argLength, argPadChar);
    }

    /**
     * w̒ɂȂ܂ŁA̍ɕǉ܂B
     * 
     * @param argSource
     *            IWiB
     * @param argLength
     *            ]钷B
     * @param argPadChar
     *            lߍ݂ɗp镶B
     * @return w̒ɉH̕Bw̒IWi񂪒ꍇɂ́AIWi񂪂̂܂ܖ߂܂B
     */
    public static final String padLeft(final String argSource,
            final int argLength, final char argPadChar) {
        return BlancoStringUtilPad.padLeft(argSource, argLength, argPadChar);
    }
}
