/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.constants.resourcebundle;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoConstants]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoConstantsResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoConstantsResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoConstants]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoConstantsResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoConstants");
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AftHg̃P[AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoConstantsResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoConstants]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoConstantsResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoConstants", locale);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AP[[" + locale.toString() + "]AĂяõNX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * BlancoConstantsResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoConstants]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoConstantsResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoConstants", locale, loader);
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AP[[" + locale.toString() + "]Aw̃NX[_gpāA\[Xoh̎擾݂܂s܂B`̐ݒl𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
    }

    /**
     * bundle[BlancoConstants], key[METAFILE_DISPLAYNAME]
     *
     * [萔`] (ja)<br>
     *
     * @return key[METAFILE_DISPLAYNAME]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMetafileDisplayname() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "萔`";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("METAFILE_DISPLAYNAME");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[METAFILE_DISPLAYNAME]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoConstants], key[META2XML.ELEMENT_COMMON]
     *
     * [blancoconstants-common] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_COMMON]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementCommon() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoconstants-common";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_COMMON");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[META2XML.ELEMENT_COMMON]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoConstants], key[META2XML.ELEMENT_LIST]
     *
     * [blancoconstants-list] (ja)<br>
     *
     * @return key[META2XML.ELEMENT_LIST]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getMeta2xmlElementList() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "blancoconstants-list";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("META2XML.ELEMENT_LIST");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[META2XML.ELEMENT_LIST]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoConstants], key[XML2JAVACLASS.ERR001]
     *
     * [萔` NX[{0}]̃pbP[Ww肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "萔` NX[{0}]̃pbP[Ww肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[XML2JAVACLASS.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoConstants], key[XML2JAVACLASS.ERR002]
     *
     * [萔` NX[{0}]̃tB[h[{1}]̌^w肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR002]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr002(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "萔` NX[{0}]̃tB[h[{1}]̌^w肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR002");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[XML2JAVACLASS.ERR002]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoConstants], key[XML2JAVACLASS.ERR003]
     *
     * [萔` NX[{0}]̃tB[h[{1}]̒lw肳Ă܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR003]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr003(final String arg0, final String arg1) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "萔` NX[{0}]̃tB[h[{1}]̒lw肳Ă܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR003");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[XML2JAVACLASS.ERR003]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoConstants], key[XML2JAVACLASS.ERR004]
     *
     * [萔` NX[{0}] tB[h[{1}]́ul({2})vZbgĂ܂Bu{3}v̓T|[g܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @param arg1 u{1}ulBjava.lang.String^^ĂB
     * @param arg2 u{2}ulBjava.lang.String^^ĂB
     * @param arg3 u{3}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.ERR004]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassErr004(final String arg0, final String arg1, final String arg2, final String arg3) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "萔` NX[{0}] tB[h[{1}]́ul({2})vZbgĂ܂Bu{3}v̓T|[g܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.ERR004");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[XML2JAVACLASS.ERR004]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0, arg1, arg2, arg3}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoConstants], key[ANTTASK.ERR001]
     *
     * [^fBNg[{0}]݂܂B] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[ANTTASK.ERR001]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getAnttaskErr001(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "^fBNg[{0}]݂܂B";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("ANTTASK.ERR001");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[ANTTASK.ERR001]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }

    /**
     * bundle[BlancoConstants], key[TARGET_DIRECTORY]
     *
     * [/constants] (ja)<br>
     *
     * @return key[TARGET_DIRECTORY]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getTargetDirectory() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "/constants";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("TARGET_DIRECTORY");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[TARGET_DIRECTORY]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoConstants], key[XML2JAVACLASS.FIELD.NO]
     *
     * [ڔԍ:{0}&lt;br&gt;] (ja)<br>
     *
     * @param arg0 u{0}ulBjava.lang.String^^ĂB
     * @return key[XML2JAVACLASS.FIELD.NO]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getXml2javaclassFieldNo(final String arg0) {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "ڔԍ:{0}<br>";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("XML2JAVACLASS.FIELD.NO");
            }
        } catch (MissingResourceException ex) {
            final String message = "ꖼ[BlancoConstants]AL[[XML2JAVACLASS.FIELD.NO]̒`擾ł܂łB`̒l𗘗pďs܂B:" + ex.toString();
            System.out.println(message);
        }
        final MessageFormat messageFormat = new MessageFormat(strFormat);
        final StringBuffer strbuf = new StringBuffer();
        // ^ꂽɒuu܂B
        messageFormat.format(new Object[] {arg0}, strbuf, null);
        return strbuf.toString();
    }
}
