/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.dbee.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXException;

import blanco.db.BlancoDbConstants;
import blanco.db.BlancoDbMeta2Xml;
import blanco.db.BlancoDbTableMeta2Xml;
import blanco.db.BlancoDbXml2JavaClass;
import blanco.db.conf.BlancoDbDatabaseConnectionSettingDef;
import blanco.db.resourcebundle.BlancoDbResourceBundle;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlDb;
import blanco.plugin.dbee.BlancoDbEEPlugin;
import blanco.plugin.dbee.editors.BlancoDbEEPluginUtil;

public class BlancoDbEEGenerateAction {
    private static final BlancoDbResourceBundle fBundle = new BlancoDbResourceBundle();

    /**
     * blancoDb\[XR[hs܂B
     * 
     * @param input
     * @return
     * @throws InvocationTargetException
     * @throws InterruptedException
     */
    public static final void processBlancoDb(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String metaDir, final String jdbcDriver,
            final String jdbcUrl, final String jdbcUser,
            final String jdbcPassword, final String jdbcSchema,
            final String basePackage, final String runtimePackage,
            final String statementTimeout, final boolean isSimpleTableProcess,
            final boolean isSqlMetaProcess, final boolean isSqlLogging)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor.beginTask(
                                        BlancoDbConstants.PRODUCT_NAME
                                                + " \[XR[h", 10);

                                // ڑ̍\z
                                final BlancoDbDatabaseConnectionSettingDef connDef = new BlancoDbDatabaseConnectionSettingDef();
                                connDef.setJdbcDriver(jdbcDriver);
                                connDef.setJdbcUrl(jdbcUrl);
                                connDef.setJdbcUser(jdbcUser);
                                connDef.setJdbcPassword(jdbcPassword);
                                if (jdbcSchema != null
                                        && jdbcSchema.length() > 0) {
                                    // XL[}wB
                                    // w肪ꍇɂ̂݃Zbĝ@łB
                                    connDef.setSchema(jdbcSchema);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: blancotH_̍쐬");
                                monitor.worked(1);

                                // blancotH_΍ŏɍ쐬܂B
                                final IFolder folderTargetDirectoryBlanco = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryBlanco.create(true,
                                            true, workbenchMonitor);
                                }
                                final File blancoTargetDirectory = folderTargetDirectoryBlanco
                                        .getLocation().toFile();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSimpleTableProcess) {
                                    processSimpleTable(ifile, shell,
                                            workbenchMonitor, basePackage,
                                            runtimePackage, statementTimeout,
                                            connDef, blancoTargetDirectory,
                                            isSqlLogging, monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                if (isSqlMetaProcess) {
                                    processSqlMeta(ifile, shell,
                                            workbenchMonitor, metaDir,
                                            basePackage, runtimePackage,
                                            statementTimeout, connDef,
                                            blancoTargetDirectory,
                                            isSqlLogging, monitor);
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: blancotH_tbV");
                                monitor.worked(1);

                                folderTargetDirectoryBlanco.refreshLocal(
                                        IResource.DEPTH_INFINITE,
                                        workbenchMonitor);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: blancotH_tbV");

                                // tmptH_𓯊
                                BlancoDbEEPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, "tmp");

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: sqltH_tbV");
                                // ܂łیƂē܂B
                                BlancoDbEEPluginUtil.refreshFolder(ifile,
                                        workbenchMonitor, metaDir);
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .getMessage());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoDbEEPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n"
                            + ex.getTargetException().getMessage());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoDbEEPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoDbEEPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoDbEEPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * P\܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param runtimePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws ClassNotFoundException
     * @throws TransformerException
     */
    private static void processSimpleTable(final IFile ifile,
            final Shell shell, final IProgressMonitor workbenchMonitor,
            final String basePackage, final String runtimePackage,
            final String statementTimeout,
            final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoTargetDirectory, final boolean isSqlLogging,
            final IProgressMonitor monitor) throws InvocationTargetException,
            InterruptedException, CoreException, SQLException, SAXException,
            IOException, ParserConfigurationException, ClassNotFoundException,
            TransformerException {
        // TableGatewayp̃e|tH_͈U폜܂B
        monitor.subTask("P\: e|tH_𐮗܂B");
        BlancoDbEEPluginUtil.deleteFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstants.TARGET_SUBDIRECTORY + "/table");
        BlancoDbEEPluginUtil.createFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstants.TARGET_SUBDIRECTORY + "/table");
        final File blancoTempDirectoryTable = ifile.getProject().getFolder(
                "tmp" + BlancoDbConstants.TARGET_SUBDIRECTORY + "/table")
                .getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: f[^x[X̒P\^擾܂B");
        monitor.worked(1);

        final BlancoDbTableMeta2Xml gateway = new BlancoDbTableMeta2Xml() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): \[" + progressItem + "]𒊏o");
                return true;
            }
        };
        gateway.process(connDef, blancoTempDirectoryTable);

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("P\: ^Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // TableGatewayXMLt@CR/O}bsO
        final BlancoDbXml2JavaClass generatorTable = new BlancoDbXml2JavaClass() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask("P\ (" + progressCurrent + "/" + progressTotal
                        + "): t@C[" + progressItem + "]R/O}bsO");
                return true;
            }
        };
        generatorTable.setLogging(isSqlLogging);
        generatorTable.process(connDef, blancoTempDirectoryTable, basePackage,
                runtimePackage, statementTimeout, blancoTargetDirectory
                        .toString());

    }

    /**
     * SQL`t@C܂B
     * 
     * @param ifile
     * @param shell
     * @param workbenchMonitor
     * @param metaDir
     * @param basePackage
     * @param runtimePackage
     * @param connDef
     * @param blancoTargetDirectory
     * @param monitor
     * @throws InvocationTargetException
     * @throws InterruptedException
     * @throws CoreException
     * @throws SQLException
     * @throws BlancoDbException
     * @throws SAXException
     * @throws IOException
     * @throws ParserConfigurationException
     * @throws TransformerException
     * @throws ClassNotFoundException
     */
    private static void processSqlMeta(final IFile ifile, final Shell shell,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final String basePackage, final String runtimePackage,
            final String statementTimeout,
            final BlancoDbDatabaseConnectionSettingDef connDef,
            final File blancoTargetDirectory, final boolean isSqlLogging,
            final IProgressMonitor monitor) throws InvocationTargetException,
            InterruptedException, CoreException, SQLException, SAXException,
            IOException, ParserConfigurationException, TransformerException,
            ClassNotFoundException {
        monitor
                .subTask(fBundle.getMetafileDisplayname()
                        + ": e|tH_𐮗܂B");
        monitor.worked(1);

        // SQL`t@Cɂ鐶
        BlancoDbEEPluginUtil.deleteFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstants.TARGET_SUBDIRECTORY + "/sql");
        BlancoDbEEPluginUtil.createFolder(ifile, workbenchMonitor, "tmp"
                + BlancoDbConstants.TARGET_SUBDIRECTORY + "/sql");
        final IFolder searchMetaDir = ifile.getProject().getFolder(metaDir);

        final File blancoTempDirectorySql = ifile.getProject().getFolder(
                "tmp" + BlancoDbConstants.TARGET_SUBDIRECTORY + "/sql")
                .getLocation().toFile();

        final File blancoTempDirectoryDocListing = ifile.getProject()
                .getFolder("tmp/doclisting").getLocation().toFile();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask(fBundle.getMetafileDisplayname() + ": "
                + fBundle.getMetafileDisplayname()
                + "̏Ƃɒԃt@C(XML)𐶐܂B");
        monitor.worked(1);

        searchMetaDir.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        // Excelt@CXMLt@C܂B
        new BlancoDbMeta2Xml() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask(fBundle.getMetafileDisplayname() + "("
                        + progressCurrent + "/" + progressTotal + "): t@C["
                        + progressItem + "]𒊏o");
                return true;
            }
        }.processDirectory(searchMetaDir.getLocation().toFile(),
                blancoTempDirectorySql.getAbsolutePath());

        monitor.subTask(fBundle.getMetafileDisplayname()
                + ": Ƃ R/O}bsO\[XR[h𐶐܂B");
        monitor.worked(1);

        // SQL`t@CXMLt@CR/O}bsO
        final BlancoDbXml2JavaClass generatorSql = new BlancoDbXml2JavaClass() {
            public boolean progress(int progressCurrent, int progressTotal,
                    String progressItem) {
                if (monitor.isCanceled()) {
                    return false;
                }
                monitor.subTask(fBundle.getMetafileDisplayname() + "("
                        + progressCurrent + "/" + progressTotal + "): t@C["
                        + progressItem + "]R/O}bsO");
                return true;
            }

        };
        generatorSql.setLogging(isSqlLogging);
        generatorSql.process(connDef, blancoTempDirectorySql, basePackage,
                runtimePackage, statementTimeout, blancoTargetDirectory
                        .toString());

        // SQL`̈ꗗ̂߂̒ԃt@C쐬B
        final BlancoDocListingXml2CombinedXmlDb doclistingDb = new BlancoDocListingXml2CombinedXmlDb();
        doclistingDb.setBasePackage(basePackage);
        doclistingDb.setRuntimePackage(runtimePackage);
        doclistingDb.process(blancoTempDirectorySql,
                blancoTempDirectoryDocListing);
    }
}