/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.db.BlancoDbConstants;
import blanco.db.BlancoDbXml2JavaClass;
import blanco.db.common.BlancoDbMeta2Xml;
import blanco.db.common.BlancoDbTableMeta2Xml;
import blanco.db.common.stringgroup.BlancoDbExecuteSqlStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * blancoDb Enterprise EditionAnt^XNB
 * 
 * @author IGA Tosiki
 */
public class BlancoDbTask extends AbstractBlancoDbTask {
    /**
     * \[XohANZTIuWFNgL܂B
     */
    private final BlancoDbResourceBundle fBundle = new BlancoDbResourceBundle();

    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoDbConstants.PRODUCT_NAME + " ("
                + BlancoDbConstants.VERSION + ")");

        try {
            System.out.println("db: begin.");
            final long startMills = System.currentTimeMillis();

            final File blancoTmpDbTableDirectory = new File(getTmpdir()
                    + "/db/table");
            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + "/db/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbSetting dbSetting = new BlancoDbSetting();
            dbSetting.setTargetDir(getTargetdir());
            dbSetting.setBasePackage(getBasepackage());
            dbSetting.setRuntimePackage(getRuntimepackage());

            dbSetting.setJdbcdriver(getJdbcdriver());
            dbSetting.setJdbcurl(getJdbcurl());
            dbSetting.setJdbcuser(getJdbcuser());
            dbSetting.setJdbcpassword(getJdbcpassword());

            if (getLog().equals("true")) {
                dbSetting.setLogging(true);
            }
            if (BlancoStringUtil.null2Blank(getStatementtimeout()).length() > 0) {
                try {
                    dbSetting.setStatementTimeout(Integer
                            .parseInt(getStatementtimeout()));
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(
                            "Xe[gg^CAEglƂĎw肳ꂽl[" + getStatementtimeout()
                                    + "]͐lƂĉ͂ł܂łBf܂B:"
                                    + ex.toString());
                }
            }
            dbSetting.setExecuteSql(new BlancoDbExecuteSqlStringGroup()
                    .convertToInt(getExecutesql()));
            if (dbSetting.getExecuteSql() == BlancoDbExecuteSqlStringGroup.NOT_DEFINED) {
                throw new IllegalArgumentException("executesqlƂĕsȒl("
                        + getExecutesql() + ")^܂B");
            }

            if (getSchema() != null) {
                // XL[}wB
                dbSetting.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // P\ANZX
                final BlancoDbTableMeta2Xml tableMeta2Xml = new BlancoDbTableMeta2Xml() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                tableMeta2Xml.process(dbSetting, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };

                generator.process(dbSetting, blancoTmpDbTableDirectory);
            }

            if (getSql() == null || getSql().equals("true")) {
                final File fileMetadir = new File(getMetadir());
                if (fileMetadir.exists() == false) {
                    throw new IllegalArgumentException("^fBNg["
                            + getMetadir() + "]݂܂B");
                }

                final BlancoDbMeta2Xml meta2Xml = new BlancoDbMeta2Xml();
                meta2Xml.setCacheMeta2Xml(getCache().equals("true"));
                meta2Xml.processDirectory(fileMetadir, blancoTmpDbSqlDirectory
                        .getAbsolutePath());

                // XMLt@CR/O}bsO
                final BlancoDbXml2JavaClass generator = new BlancoDbXml2JavaClass() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                generator.process(dbSetting, blancoTmpDbSqlDirectory);
            }

            final long endMills = System.currentTimeMillis() - startMills;
            System.out.println("db: end: " + (endMills / 1000) + " sec.");
        } catch (SQLException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr006()
                    + e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("͒lG[:" + e.toString());
        }
    }
}
