/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.dbmetadata;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.List;

import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataKeyStructure;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataTableStructure;

/**
 * f[^x[X烁^擾CSVɏo͂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoDbMetaDataMeta2Csv {
    /**
     * f[^x[X̃^擾܂B
     * 
     * @param argJdbcDriverName
     *            JDBChCoB
     * @param argJdbcUrl
     *            JDBCڑURLB
     * @param argJdbcUser
     *            JDBCڑ[UB
     * @param argJdbcPassword
     *            JDBCڑpX[hB
     * @param argSchema
     *            XL[}BɒlꍇɂnullwB
     * @param argTable
     *            e[uBɒlꍇɂnullwB
     * @throws SQLException
     *             eOꍇB
     * @throws IOException
     */
    public void process(final String argJdbcDriverName,
            final String argJdbcUrl, final String argJdbcUser,
            final String argJdbcPassword, final String argSchema,
            final String argTable, final File targetDir) throws SQLException,
            IOException {
        System.out.println("f[^x[Xڑ: Jn: [" + argJdbcDriverName + "], ["
                + argJdbcUrl + "], [" + argJdbcUser + "]");
        final Connection conn = BlancoDbMetaDataUtil.connect(argJdbcDriverName,
                argJdbcUrl, argJdbcUser, argJdbcPassword);

        if (false) {
            System.out.println("݊Jc");
            List listInParam = new ArrayList();
            BlancoDbMetaDataColumnStructure sqlIn = new BlancoDbMetaDataColumnStructure();
            sqlIn.setName("field1");
            sqlIn.setDataType(Types.INTEGER);
            listInParam.add(sqlIn);
            List listResult = BlancoDbMetaDataSql.getResultSetMetaData(conn,
                    "SELECT * FROM AUTHOR WHERE AUTHOR_CODE = ?", listInParam);
            for (int index = 0; index < listResult.size(); index++) {
                final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) listResult
                        .get(index);
                System.out.println(columnStructure.toString());
            }

            BlancoDbMetaDataSql.getResultSetMetaData(conn,
                    "SELECT * FROM BOOK", new ArrayList());

            if (false) {
                listResult = BlancoDbMetaDataSql.getResultSetMetaData(conn,
                        "SELECT * FROM TEST_ALL_COLUMN_PRIMARY1");
                for (int index = 0; index < listResult.size(); index++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) listResult
                            .get(index);
                    System.out.println(columnStructure.toString());
                }
            }

            return;
        }

        List listTables = null;

        try {
            // R~bgOFFɐݒ肵܂B
            conn.setAutoCommit(false);

            listTables = BlancoDbMetaDataTable.getTablesWithColumns(conn,
                    argSchema, argTable, new String[] { "TABLE" });
        } finally {
            // ㏈s܂B
            conn.rollback();
            conn.close();
            System.out.println("f[^x[Xڑ: I");
        }

        writeCsvForMetaInfo(listTables, targetDir);
        writeCsvForDataInput(listTables, targetDir);
    }

    /**
     * f[^x[XpCSVt@C쐬܂B
     * 
     * @throws IOException
     * 
     */
    private void writeCsvForMetaInfo(final List listTables, final File targetDir)
            throws IOException {
        for (int indexTable = 0; indexTable < listTables.size(); indexTable++) {
            final BlancoDbMetaDataTableStructure tableStructure = (BlancoDbMetaDataTableStructure) listTables
                    .get(indexTable);

            final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            final BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(outStream));

            try {
                writeTableInfo(tableStructure, writer);
                writer.newLine();

                writer.write(",^(),NULL,L[,Q,Q,ftHg,l");
                writer.newLine();

                for (int indexColumn = 0; indexColumn < tableStructure
                        .getColumns().size(); indexColumn++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) tableStructure
                            .getColumns().get(indexColumn);

                    writer.write(columnStructure.getName());
                    writer.write(",");

                    writeColumnTypeName(columnStructure, writer);
                    writer.write(",");

                    if (columnStructure.getNullable() == ResultSetMetaData.columnNoNulls) {
                        writer.write("");
                    } else if (columnStructure.getNullable() == ResultSetMetaData.columnNullableUnknown) {
                        writer.write("H");
                    }

                    writer.write(",");

                    {
                        boolean isPrimaryKey = false;
                        for (int indexPrimaryKey = 0; indexPrimaryKey < tableStructure
                                .getPrimaryKeys().size(); indexPrimaryKey++) {
                            final BlancoDbMetaDataKeyStructure primaryKeyStructure = (BlancoDbMetaDataKeyStructure) tableStructure
                                    .getPrimaryKeys().get(indexPrimaryKey);
                            if (primaryKeyStructure.getPkcolumnName().equals(
                                    columnStructure.getName())) {
                                isPrimaryKey = true;
                            }
                        }
                        if (isPrimaryKey) {
                            writer.write("");
                        }
                    }

                    writer.write(",");

                    {
                        boolean isExportedKey = false;
                        for (int indexExportedKey = 0; indexExportedKey < tableStructure
                                .getExportedKeys().size(); indexExportedKey++) {
                            final BlancoDbMetaDataKeyStructure exportedKeyStructure = (BlancoDbMetaDataKeyStructure) tableStructure
                                    .getExportedKeys().get(indexExportedKey);
                            if (exportedKeyStructure.getPkcolumnName().equals(
                                    columnStructure.getName())) {
                                isExportedKey = true;
                            }
                        }
                        if (isExportedKey) {
                            // ̃L[QƂĂL[̃XgɂẮAcrossReferenceKeys擾܂B
                            final ArrayList listForeignKey = tableStructure
                                    .getCrossReferenceKeys();
                            for (int indexKey = 0; indexKey < listForeignKey
                                    .size(); indexKey++) {
                                final BlancoDbMetaDataKeyStructure importedKeyStructure = (BlancoDbMetaDataKeyStructure) listForeignKey
                                        .get(indexKey);
                                if (indexKey != 0) {
                                    writer.write(" ");
                                }
                                writer.write("["
                                        + importedKeyStructure.getFktableName()
                                        + "."
                                        + importedKeyStructure
                                                .getFkcolumnName() + "("
                                        + importedKeyStructure.getFkName()
                                        + ")]");
                            }
                        }
                    }

                    writer.write(",");

                    {
                        BlancoDbMetaDataKeyStructure foundKeyStructure = null;
                        boolean isImportedKey = false;
                        for (int indexImportedKey = 0; indexImportedKey < tableStructure
                                .getImportedKeys().size(); indexImportedKey++) {
                            final BlancoDbMetaDataKeyStructure importedKeyStructure = (BlancoDbMetaDataKeyStructure) tableStructure
                                    .getImportedKeys().get(indexImportedKey);
                            if (importedKeyStructure.getFkcolumnName().equals(
                                    columnStructure.getName())) {
                                isImportedKey = true;
                                foundKeyStructure = importedKeyStructure;
                            }
                        }
                        if (isImportedKey) {
                            writer.write("["
                                    + foundKeyStructure.getPktableName() + "."
                                    + foundKeyStructure.getPkcolumnName() + "("
                                    + foundKeyStructure.getFkName() + ")]");
                        }
                    }

                    writer.write(",");

                    writer.write(BlancoStringUtil.null2Blank(columnStructure
                            .getColumnDef()));

                    writer.write(",");

                    writer.write(BlancoStringUtil.null2Blank(columnStructure
                            .getRemarks()));

                    writer.newLine();
                }

                writer.flush();
                outStream.flush();

                final File fileTarget = new File(targetDir.getAbsolutePath()
                        + "/" + tableStructure.getName() + ".csv");
                switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                        .toByteArray(), fileTarget)) {
                case 0:
                    break;
                case 1:
                    System.out.println("dbmeta: " + "create: "
                            + fileTarget.getAbsolutePath());
                    break;
                case 2:
                    System.out.println("dbmeta: " + "update: "
                            + fileTarget.getAbsolutePath());
                    break;
                }
            } finally {
                writer.close();
            }
        }
    }

    /**
     * f[^͗pCSVt@C쐬܂B
     * 
     * @throws IOException
     * 
     */
    private void writeCsvForDataInput(final List listTables,
            final File targetDir) throws IOException {
        for (int indexTable = 0; indexTable < listTables.size(); indexTable++) {
            final BlancoDbMetaDataTableStructure tableStructure = (BlancoDbMetaDataTableStructure) listTables
                    .get(indexTable);

            final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            final BufferedWriter writer = new BufferedWriter(
                    new OutputStreamWriter(outStream));

            try {
                writeTableInfo(tableStructure, writer);
                writer.newLine();

                for (int indexColumn = 0; indexColumn < tableStructure
                        .getColumns().size(); indexColumn++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) tableStructure
                            .getColumns().get(indexColumn);

                    if (indexColumn != 0) {
                        writer.write(",");
                    }

                    writer.write(columnStructure.getName());
                }
                writer.newLine();

                for (int indexColumn = 0; indexColumn < tableStructure
                        .getColumns().size(); indexColumn++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) tableStructure
                            .getColumns().get(indexColumn);

                    if (indexColumn != 0) {
                        writer.write(",");
                    }

                    writeColumnTypeName(columnStructure, writer);
                }
                writer.newLine();

                // L[ǂ\B
                for (int indexColumn = 0; indexColumn < tableStructure
                        .getColumns().size(); indexColumn++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) tableStructure
                            .getColumns().get(indexColumn);

                    if (indexColumn != 0) {
                        writer.write(",");
                    }

                    boolean isPrimaryKey = false;
                    for (int indexPrimaryKey = 0; indexPrimaryKey < tableStructure
                            .getPrimaryKeys().size(); indexPrimaryKey++) {
                        final BlancoDbMetaDataKeyStructure primaryKeyStructure = (BlancoDbMetaDataKeyStructure) tableStructure
                                .getPrimaryKeys().get(indexPrimaryKey);
                        if (primaryKeyStructure.getPkcolumnName().equals(
                                columnStructure.getName())) {
                            isPrimaryKey = true;
                        }
                    }
                    if (isPrimaryKey) {
                        writer.write("L[");
                    }
                }
                writer.newLine();

                // NULLǂ\B
                for (int indexColumn = 0; indexColumn < tableStructure
                        .getColumns().size(); indexColumn++) {
                    final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) tableStructure
                            .getColumns().get(indexColumn);

                    if (indexColumn != 0) {
                        writer.write(",");
                    }

                    if (columnStructure.getNullable() == ResultSetMetaData.columnNoNulls) {
                        writer.write("NULL");
                    }
                }

                writer.newLine();

                writer.flush();
                outStream.flush();

                final File fileTarget = new File(targetDir.getAbsolutePath()
                        + "/" + tableStructure.getName() + ".data.csv");
                switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                        .toByteArray(), fileTarget)) {
                case 0:
                    break;
                case 1:
                    System.out.println("dbmeta: data: " + "create: "
                            + fileTarget.getAbsolutePath());
                    break;
                case 2:
                    System.out.println("dbmeta: data: " + "update: "
                            + fileTarget.getAbsolutePath());
                    break;
                }
            } finally {
                writer.close();
            }
        }
    }

    /**
     * \ɊւʓIȏo͂܂B
     * 
     * @param tableStructure
     * @param writer
     * @throws IOException
     */
    private void writeTableInfo(
            final BlancoDbMetaDataTableStructure tableStructure,
            final BufferedWriter writer) throws IOException {
        writer.write("\,^Cv,J^O,XL[},l");
        writer.newLine();
        writer.write(tableStructure.getName());
        writer.write(",");
        writer.write(BlancoStringUtil.null2Blank(tableStructure.getType()));
        writer.write(",");
        writer.write(BlancoStringUtil.null2Blank(tableStructure.getCatalog()));
        writer.write(",");
        writer.write(BlancoStringUtil.null2Blank(tableStructure.getSchema()));
        writer.write(",");
        writer.write(BlancoStringUtil.null2Blank(tableStructure.getRemarks()));
        writer.newLine();
    }

    /**
     * ڂ̌^o͂܂B
     * 
     * @param columnStructure
     * @param writer
     * @throws IOException
     */
    private void writeColumnTypeName(
            final BlancoDbMetaDataColumnStructure columnStructure,
            final BufferedWriter writer) throws IOException {
        writer.write(columnStructure.getTypeName());

        // ^ɂ TCY\؂ւ܂B
        if (columnStructure.getColumnSize() < 0) {
            // TCY0菬ꍇɂ́ATCY͕\܂B
            // PostgreSQL̏ꍇɁA-1߂dlłB
        } else if (columnStructure.getDataTypeDisplayName().equals("NUMERIC")
                || columnStructure.getDataTypeDisplayName().equals("DECIMAL")) {
            writer.write(" (" + columnStructure.getColumnSize() + "."
                    + columnStructure.getDecimalDigits() + ")");
        } else if (columnStructure.getDataTypeDisplayName().equals("BIT")
                || columnStructure.getDataTypeDisplayName().equals("TINYINT")
                || columnStructure.getDataTypeDisplayName().equals("SMALLINT")
                || columnStructure.getDataTypeDisplayName().equals("INTEGER")
                || columnStructure.getDataTypeDisplayName().equals("FLOAT")
                || columnStructure.getDataTypeDisplayName().equals("REAL")
                || columnStructure.getDataTypeDisplayName().equals("DOUBLE")
                || columnStructure.getDataTypeDisplayName().equals("DATE")
                || columnStructure.getDataTypeDisplayName().equals("TIME")
                || columnStructure.getDataTypeDisplayName().equals("TIMESTAMP")
                || columnStructure.getDataTypeDisplayName().equals("NULL")
                || columnStructure.getDataTypeDisplayName().equals("BOOLEAN")) {
            // o͂܂B
        } else {
            writer.write(" (" + columnStructure.getColumnSize() + ")");
        }
    }
}
