/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.util.BlancoDbQueryParserUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class GetQueryMethod extends BlancoDbAbstractMethod {
    public GetQueryMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod("getQuery",
                "SQL`ŗ^ꂽSQL擾܂B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.setReturn(fCgFactory.createReturn("java.lang.String",
                "JDBChCoɗ^Ďs\ȏԂSQLB"));

        cgMethod
                .getLangDoc()
                .getDescriptionList()
                .add(
                        "SQL̓p[^Ƃ #L[[hɂw肪ꍇɂ́AYӏ ? ɒu SQL擾ł܂B");

        final List listLine = cgMethod.getLineList();

        // 2005.04.15 t.iga s͉sƂďo͂悤ɕύXB
        // 2005.10.12 t.iga blancoCommons̕ϊ[eBeB𗘗p悤ɕύXB
        final String escapedQuery = BlancoJavaSourceUtil
                .escapeStringAsJavaSource(fSqlInfo.getQuery());

        // NG #p[^?ւ̕ϊ
        final String actualSql = new BlancoDbQueryParserUtil(escapedQuery)
                .getNaturalSqlStringForJava();

        listLine.add("return \"" + actualSql + "\";");
    }
}