/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.doclisting.task;

import java.io.File;

import org.apache.tools.ant.BuildException;

import blanco.doclisting.BlancoDocListingXml2CombinedXmlResourceBundle;
import blanco.doclisting.resourcebundle.BlancoDocListingResourceBundle;

/**
 * BlancoDocListingCombineXmlTask Ant Task
 */
public class BlancoDocListingCombineXmlResourceBundleTask extends
        AbstractBlancoDocListingCombineXmlResourceBundleTask {
    private final BlancoDocListingResourceBundle bundle = new BlancoDocListingResourceBundle();

    protected void process() throws IllegalArgumentException {
        final File fileInputdir = new File(getInputdir());
        if (fileInputdir.exists() == false) {
            throw new BuildException(bundle.getTaskErr001(getInputdir()));
        }

        new BlancoDocListingXml2CombinedXmlResourceBundle().process(
                fileInputdir, new File(getOutputdir()));
    }
}
