/*
 * blanco Framework
 * Copyright (C) 2004-2006 WATANABE Yoshinori
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.sql.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Stack;

/**
 * BlancoSqlFormatter: SQL`c[. SQL߂ꂽ[ɏ]`܂B <br>
 * SQLƂĐƂOłB
 * http://homepage2.nifty.com/igat/igapyon/diary/2005/ig050613.html <br>
 * 2005.08.08 Tosiki Iga: ( ) ɂĂ (*) ̂悤ɂЂ悤ɕύXB <br>
 * 2005.08.03 Tosiki Iga: ߂ꂽOX[悤ɕύX܂B
 * 
 * @author Yoshinori WATANABE (a-san) : original version at 2005.07.04.
 * @author Tosiki Iga : marge into blanc Framework at 2005.07.04
 */
public class BlancoSqlFormatter {
    BlancoSqlParser parser = new BlancoSqlParser();

    BlancoSqlRule rule = null;

    /**
     * SQL`c[쐬܂B
     * 
     * @param rule
     *            SQLϊ[
     */
    public BlancoSqlFormatter(BlancoSqlRule rule) {
        this.rule = rule;
    }

    /**
     * SQL𐮌`܂. <br>
     * 1.sŏISQĹA`stł悤ɂ܂B
     * 
     * @param sql
     *            `OSQL
     * @return `SQL
     * @throws BlancoSqlFormatterException
     *             IɔO͑SẴNXɂȂ܂B
     */
    public String format(String sql) throws BlancoSqlFormatterException {
        try {
            boolean isSqlEndsWithNewLine = false;
            if (sql.endsWith("\n")) {
                isSqlEndsWithNewLine = true;
            }

            List list = parser.parse(sql);
            // for (int i=0; i<list.size(); i++) {
            // Token t = (Token) list.get(i);
            // System.out.println(""+i+":"+t);
            // }
            list = format(list);
            // ϊʂ𕶎ɖ߂B
            String after = "";
            for (int i = 0; i < list.size(); i++) {
                BlancoSqlToken t = (BlancoSqlToken) list.get(i);
                after += t.s;
            }

            if (isSqlEndsWithNewLine) {
                after += "\n";
            }
            return after;
        } catch (Exception ex) {
            BlancoSqlFormatterException sqlException = new BlancoSqlFormatterException(
                    ex.toString());
            sqlException.initCause(ex);
            throw sqlException;
        }
    }

    /**
     * ̔zAw肳ꂽSQLKɏ]ĕϊ܂B
     * 
     * @param list
     *            ϊO̎̔zBArrayList <Token>
     * @return ϊ̎̔zBArrayList <Token>
     */
    private List format(List list) {

        // TODO:AȂ̍sɕϊĉB
        // ȂׂVvŖmȃ[ɂĂB
        // NgȂ悤ȕsKvȑI͂߂܂傤B

        // SQL̑Oɋ󔒂ƍ폜B
        BlancoSqlToken t = (BlancoSqlToken) list.get(0);
        if (t.type == BlancoSqlToken.SPACE)
            list.remove(0);
        t = (BlancoSqlToken) list.get(list.size() - 1);
        if (t.type == BlancoSqlToken.SPACE)
            list.remove(list.size() - 1);

        // SQLL[[h͑啶ƂBor ...
        for (int i = 0; i < list.size(); i++) {
            t = (BlancoSqlToken) list.get(i);
            if (t.type == BlancoSqlToken.KEYWORD) {
                switch (rule.keyword) {
                case BlancoSqlRule.KEYWORD_NONE:
                    break;
                case BlancoSqlRule.KEYWORD_UPPER_CASE:
                    t.s = t.s.toUpperCase();
                    break;
                case BlancoSqlRule.KEYWORD_LOWER_CASE:
                    t.s = t.s.toLowerCase();
                    break;
                }
            }
        }

        // AL̑Ő󔒂
        for (int i = list.size() - 1; i >= 1; i--) {
            t = (BlancoSqlToken) list.get(i);
            BlancoSqlToken prev = (BlancoSqlToken) list.get(i - 1);
            if (t.type == BlancoSqlToken.SPACE
                    && (prev.type == BlancoSqlToken.SYMBOL || prev.type == BlancoSqlToken.COMMENT)) {
                list.remove(i);
            } else if ((t.type == BlancoSqlToken.SYMBOL || t.type == BlancoSqlToken.COMMENT)
                    && prev.type == BlancoSqlToken.SPACE) {
                list.remove(i - 1);
            } else if (t.type == BlancoSqlToken.SPACE) {
                t.s = " ";
            }
        }

        // Q񂾃L[[h͂P̃L[[hƂ݂ȂB(ex."INSERT INTO", "ORDER BY")
        // ߑ̌̓L[[hQԂƂ͂ȂBÂł́ARi܂lԂ̌j
        // ߂Â邽߁AL[[hQԂƂBAߑł"ORDER_BY"A邢"OrderBy"
        // ̂悤ɁAǐ𑹂ȂƂȂA͂₷@̗pĂB
        for (int i = list.size() - 1; i >= 2; i--) {
            BlancoSqlToken t0 = (BlancoSqlToken) list.get(i);
            BlancoSqlToken t1 = (BlancoSqlToken) list.get(i - 1);
            BlancoSqlToken t2 = (BlancoSqlToken) list.get(i - 2);
            if (t0.type == BlancoSqlToken.KEYWORD
                    && t1.type == BlancoSqlToken.SPACE
                    && t2.type == BlancoSqlToken.KEYWORD) {
                if (((t2.s.equalsIgnoreCase("ORDER") || t2.s
                        .equalsIgnoreCase("GROUP")) && t0.s
                        .equalsIgnoreCase("BY"))) {
                    t2.s = t2.s + " " + t0.s;
                    list.remove(i - 1);
                    list.remove(i - 1);
                }
            }
        }

        // Cfg𐮂B
        int indent = 0;
        Stack bracketIndent = new Stack(); // ۃJbR̃CfgʒuoB
        for (int i = 0; i < list.size(); i++) {
            t = (BlancoSqlToken) list.get(i);
            // System.out.println("@@@"+i+"@"+t);
            if (t.type == BlancoSqlToken.SYMBOL) {
                // indentP₵A'('̂ƂŉsB
                if (t.s.equals("(")) {
                    bracketIndent.push(new Integer(indent));
                    indent++;
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
                // indentP₵A')'̑OƌŉsB
                else if (t.s.equals(")")) {
                    indent = ((Integer) bracketIndent.pop()).intValue();
                    // indent--;
                    i += insertReturnAndIndent(list, i, indent);
                    // i += insertReturnAndIndent(list, i+1, indent);
                }
                // ','̑Oŉs
                else if (t.s.equals(",")) {
                    i += insertReturnAndIndent(list, i, indent);
                } else if (t.s.equals(";")) {
                    // 2005.07.26 Tosiki Iga Ƃ肠Z~RSQLԂȂ悤ɉ
                    indent = 0;
                    i += insertReturnAndIndent(list, i, indent);
                }
            } else if (t.type == BlancoSqlToken.KEYWORD) {
                // indentQ₵AL[[ȟŉs
                if (t.s.equalsIgnoreCase("DELETE")
                        || t.s.equalsIgnoreCase("SELECT")
                        || t.s.equalsIgnoreCase("UPDATE")) {
                    indent += 2;
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
                // indentP₵AL[[ȟŉs
                if (t.s.equalsIgnoreCase("INSERT")
                        || t.s.equalsIgnoreCase("INTO")
                        || t.s.equalsIgnoreCase("CREATE")
                        || t.s.equalsIgnoreCase("DROP")
                        || t.s.equalsIgnoreCase("TRUNCATE")
                        || t.s.equalsIgnoreCase("TABLE")
                        || t.s.equalsIgnoreCase("CASE")) {
                    indent++;
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
                // L[[h̑OindentP炵ĉsAL[[ȟindent߂ĉsB
                if (t.s.equalsIgnoreCase("FROM")
                        || t.s.equalsIgnoreCase("WHERE")
                        || t.s.equalsIgnoreCase("SET")
                        || t.s.equalsIgnoreCase("ORDER BY")
                        || t.s.equalsIgnoreCase("GROUP BY")
                        || t.s.equalsIgnoreCase("HAVING")) {
                    i += insertReturnAndIndent(list, i, indent - 1);
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
                // L[[h̑OindentP炵ĉsAL[[ȟindent߂ĉsB
                if (t.s.equalsIgnoreCase("VALUES")) {
                    indent--;
                    i += insertReturnAndIndent(list, i, indent);
                }
                // L[[h̑OindentP炵ĉs
                if (t.s.equalsIgnoreCase("END")) {
                    indent--;
                    i += insertReturnAndIndent(list, i, indent);
                }
                // L[[h̑Oŉs
                if (t.s.equalsIgnoreCase("OR") || t.s.equalsIgnoreCase("AND")
                        || t.s.equalsIgnoreCase("THEN")
                        || t.s.equalsIgnoreCase("ELSE")) {
                    i += insertReturnAndIndent(list, i, indent);
                }
                // L[[h̑Oŉs
                if (t.s.equalsIgnoreCase("ON") || t.s.equalsIgnoreCase("USING")) {
                    i += insertReturnAndIndent(list, i, indent + 1);
                }
                // L[[h̑OŉsBindentIɂOɂB
                if (t.s.equalsIgnoreCase("UNION")
                        || t.s.equalsIgnoreCase("INTERSECT")
                        || t.s.equalsIgnoreCase("EXCEPT")) {
                    indent -= 2;
                    i += insertReturnAndIndent(list, i, indent);
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
            } else if (t.type == BlancoSqlToken.COMMENT) {
                // System.out.println(">>>"+t.s);
                if (t.s.startsWith("/*")) {
                    // }`CRǧɉsB
                    i += insertReturnAndIndent(list, i + 1, indent);
                }
            }
        }

        /*
         * ۃJbRň͂܂ꂽ (ЂƂ̍)ɂĂ͓ʈsB @author tosiki iga
         */
        for (int i = list.size() - 1; i >= 4; i--) {
            if (i >= list.size()) {
                continue;
            }
            BlancoSqlToken t0 = (BlancoSqlToken) list.get(i);
            BlancoSqlToken t1 = (BlancoSqlToken) list.get(i - 1);
            BlancoSqlToken t2 = (BlancoSqlToken) list.get(i - 2);
            BlancoSqlToken t3 = (BlancoSqlToken) list.get(i - 3);
            BlancoSqlToken t4 = (BlancoSqlToken) list.get(i - 4);

            if (t4.s.equalsIgnoreCase("(") && t3.s.trim().equalsIgnoreCase("")
                    && t1.s.trim().equalsIgnoreCase("")
                    && t0.s.equalsIgnoreCase(")")) {
                t4.s = t4.s + t2.s + t0.s;
                list.remove(i);
                list.remove(i - 1);
                list.remove(i - 2);
                list.remove(i - 3);
            }
        }

        // OɃXy[X
        for (int i = 1; i < list.size(); i++) {
            BlancoSqlToken prev = (BlancoSqlToken) list.get(i - 1);
            t = (BlancoSqlToken) list.get(i);
            if (prev.type != BlancoSqlToken.SPACE
                    && t.type != BlancoSqlToken.SPACE) {
                // J}̌ɂ̓Xy[XȂ
                if (prev.s.equals(","))
                    continue;
                list.add(i, new BlancoSqlToken(BlancoSqlToken.SPACE, " "));
            }
        }
        return list;
    }

    /**
     * sƃCfg}.
     * 
     * @return 󔒂}ꍇ͂PA󔒂uꍇ͂OԂB
     */
    private int insertReturnAndIndent(List list, int index, int indent) {
        try {
            // }镶쐬B
            String s = "\n";
            // POɃVOCRgȂAs͕svB
            BlancoSqlToken prev = (BlancoSqlToken) (list.get(index - 1));
            if (prev.type == BlancoSqlToken.COMMENT && prev.s.startsWith("--")) {
                s = "";
            }
            // CfgB
            for (int j = 0; j < indent; j++)
                s += rule.indentString;
            // OɂłɃXy[X΁AuB
            BlancoSqlToken t = (BlancoSqlToken) list.get(index);
            if (t.type == BlancoSqlToken.SPACE) {
                t.s = s;
                return 0;
            }
            t = (BlancoSqlToken) list.get(index - 1);
            if (t.type == BlancoSqlToken.SPACE) {
                t.s = s;
                return 0;
            }
            // OɂȂ΁AVɃXy[XǉB
            list.add(index, new BlancoSqlToken(BlancoSqlToken.SPACE, s));
            return 1;
        } catch (IndexOutOfBoundsException e) {
            // e.printStackTrace();
            return 0;
        }
    }

    public static void main(String[] args) throws Exception {
        // [ݒ肷
        BlancoSqlRule rule = new BlancoSqlRule();
        rule.keyword = BlancoSqlRule.KEYWORD_UPPER_CASE;
        rule.indentString = "    ";
        BlancoSqlFormatter formatter = new BlancoSqlFormatter(rule);

        // eXgfBNg̃t@CꊇŕϊB
        File[] files = new File("Test").listFiles();
        for (int i = 0; i < files.length; i++) {
            System.out.println("-- " + files[i]);
            // t@CSQLǂݍ.
            BufferedReader reader = new BufferedReader(new FileReader(files[i]));
            String before = "";
            while (reader.ready()) {
                String line = reader.readLine();
                if (line == null)
                    break;
                before += line + "\n";
            }
            reader.close();

            // `
            System.out.println("[before]\n" + before);
            String after = formatter.format(before);
            System.out.println("[after]\n" + after);
        }
    }
}
