/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.valueobject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.valueobject.resourcebundle.BlancoValueObjectResourceBundle;
import blanco.valueobject.util.BlancoValueObjectUtil;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * ValueObject\钆XMLt@C Java\[XR[hNXB
 * 
 * blancoValueObject̎傽NX̂ЂƂłB
 * 
 * @author IGA Tosiki
 */
public class BlancoValueObjectXml2JavaClass {
    /**
     * \[XohIuWFNgB
     */
    private final BlancoValueObjectResourceBundle fBundle = new BlancoValueObjectResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * tB[h⃁\bh̖Oό`sǂB
     */
    private boolean fNameAdjust = true;

    /**
     * blancoValueObject 0.8.0G~[g邩ǂB
     */
    private boolean fEmulateVersion080 = false;

    /**
     * o[W0.8.0G~[g邩ǂB
     * 
     * @param argEmulateVersion
     */
    public void setEmulateVersion080(final boolean argEmulateVersion) {
        fEmulateVersion080 = argEmulateVersion;
    }

    /**
     * ValueObject\钆XMLt@C Java\[XR[h܂B
     * 
     * @param metaXmlSourceFile
     *            ValueObjectɊւ郁^񂪊܂܂ĂXMLt@C
     * @param directoryTarget
     *            \[XR[hfBNg
     * @throws IOException
     *             o͗Oꍇ
     */
    public void process(final File metaXmlSourceFile, final File directoryTarget)
            throws IOException {

        final DOMResult result = BlancoXmlUtil
                .transformFile2Dom(metaXmlSourceFile);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName(fBundle
                                .getMeta2xmlElementCommon());
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                // ŏ̃ACêݏĂ܂B
                final Element elementCommon = (Element) listCommon.item(0);
                final String name = BlancoXmlUtil.getTextContent(elementCommon,
                        "name");
                if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                    continue;
                }

                final BlancoValueObjectClassStructure objClassStructure = parseElementSheet(elementSheet);

                /**
                 * ꂽ񂩂Java\[XR[h𐶐܂B
                 */
                valueObject2JavaSource(objClassStructure, directoryTarget);
            }
        }
    }

    /**
     * XMLt@Cp[X܂B
     * 
     * ̃\bh͒ڌĂяo邱Ƃ͑z肵Ă܂B
     * 
     * @param elementSheet
     *            V[gGgB
     * @return p[X̌ʓꂽo[IuWFNgENXB
     */
    public BlancoValueObjectClassStructure parseElementSheet(
            final Element elementSheet) {
        final BlancoValueObjectClassStructure objClassStructure = new BlancoValueObjectClassStructure();
        final NodeList listCommon = elementSheet.getElementsByTagName(fBundle
                .getMeta2xmlElementCommon());
        final Element elementCommon = (Element) listCommon.item(0);
        objClassStructure.setName(BlancoXmlUtil.getTextContent(elementCommon,
                "name"));
        objClassStructure.setPackage(BlancoXmlUtil.getTextContent(
                elementCommon, "package"));
        objClassStructure.setJavadoc(BlancoXmlUtil.getTextContent(
                elementCommon, "description"));
        objClassStructure.setFilecomment(BlancoXmlUtil.getTextContent(
                elementCommon, "fileDescription"));
        objClassStructure.setListField(new ArrayList());

        if (objClassStructure.getPackage() == null) {
            throw new IllegalArgumentException(fBundle
                    .getXml2javaclassErr001(objClassStructure.getName()));
        }

        final NodeList listList = elementSheet.getElementsByTagName(fBundle
                .getMeta2xmlElementList());
        final Element elementListRoot = (Element) listList.item(0);
        final NodeList listChildNodes = elementListRoot.getChildNodes();
        for (int index = 0; index < listChildNodes.getLength(); index++) {
            if (listChildNodes.item(index) instanceof Element == false) {
                continue;
            }
            final Element elementList = (Element) listChildNodes.item(index);
            final BlancoValueObjectFieldStructure fieldStructure = new BlancoValueObjectFieldStructure();

            fieldStructure.setNo(BlancoXmlUtil
                    .getTextContent(elementList, "no"));
            fieldStructure.setName(BlancoXmlUtil.getTextContent(elementList,
                    "name"));
            if (fieldStructure.getName() == null
                    || fieldStructure.getName().trim().length() == 0) {
                continue;
            }

            fieldStructure.setType(BlancoXmlUtil.getTextContent(elementList,
                    "type"));
            fieldStructure.setJavadoc(BlancoXmlUtil.getTextContent(elementList,
                    "description"));
            fieldStructure.setDefault(BlancoXmlUtil.getTextContent(elementList,
                    "default"));
            fieldStructure.setMinLength(BlancoXmlUtil.getTextContent(
                    elementList, "minLength"));
            fieldStructure.setMaxLength(BlancoXmlUtil.getTextContent(
                    elementList, "maxLength"));
            fieldStructure.setLength(BlancoXmlUtil.getTextContent(elementList,
                    "length"));
            fieldStructure.setMinInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "minInclusive"));
            fieldStructure.setMaxInclusive(BlancoXmlUtil.getTextContent(
                    elementList, "maxInclusive"));
            fieldStructure.setPattern(BlancoXmlUtil.getTextContent(elementList,
                    "pattern"));

            if (fieldStructure.getType() == null
                    || fieldStructure.getType().trim().length() == 0) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr002(objClassStructure.getName(),
                                fieldStructure.getName()));
            }

            objClassStructure.getListField().add(fieldStructure);
        }

        return objClassStructure;
    }

    /**
     * ^ꂽNXo[IuWFNgƂJava\[XR[h𐶐܂B
     * 
     * ̃\bh͒ڌĂяo邱Ƃ͑z肵Ă܂B
     * 
     * @param classInfo
     *            NX
     * @param directoryTarget
     *            Java\[XR[h̏o͐fBNg
     * @throws IOException
     *             o͗OꍇB
     */
    public void valueObject2JavaSource(
            final BlancoValueObjectClassStructure classInfo,
            final File directoryTarget) throws IOException {
        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();

        if (fEmulateVersion080 == false) {
            fCgSourceFile = fCgFactory.createSourceFile(classInfo.getPackage(),
                    "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        } else {
            fCgSourceFile = fCgFactory.createSourceFile(classInfo.getPackage(),
                    "This code is generated by blanco Framework.");
        }

        fCgClass = fCgFactory.createClass(classInfo.getName(), "");
        fCgSourceFile.getClassList().add(fCgClass);

        if (classInfo.getFilecomment() != null) {
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(classInfo
                            .getFilecomment());
            for (int index = 0; index < lines.length; index++) {
                fCgSourceFile.getLangDoc().getDescriptionList().add(
                        lines[index]);
            }
        }

        if (classInfo.getJavadoc() != null) {
            final String[] lines = BlancoValueObjectUtil
                    .escapeStringAsJavaDocWithNewLine(classInfo.getJavadoc());
            for (int index = 0; index < lines.length; index++) {
                fCgClass.getLangDoc().getDescriptionList().add(lines[index]);
            }
        }

        for (int indexField = 0; indexField < classInfo.getListField().size(); indexField++) {
            final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                    .getListField().get(indexField);

            if (field.getName() == null) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr003(classInfo.getName()));
            }
            if (field.getType() == null) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr004(classInfo.getName(), field
                                .getName()));
            }

            final String fieldNameAdjustered = (getNameAdjust() == false ? field
                    .getName()
                    : BlancoNameAdjuster.toClassName(field.getName()));

            final BlancoCgField field1 = fCgFactory.createField("f"
                    + fieldNameAdjustered, field.getType(), fBundle
                    .getXml2javaclassFieldName(field.getName()));
            fCgClass.getFieldList().add(field1);

            if (fEmulateVersion080) {
                field1.setDescription(null);
                field1.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2javaclassFieldName(field.getName())
                                + "<br>");
            }

            field1.getLangDoc().getDescriptionList().add(
                    fBundle.getXml2javaclassFieldType(field.getType()));
            if (field.getDefault() != null) {
                field1.getLangDoc().getDescriptionList().add(
                        fBundle
                                .getXml2javaclassFieldDefault(field
                                        .getDefault()));
                if (field.getType().equals("java.lang.String")) {
                    // _uNI[gt^܂B
                    field1.setDefault("\""
                            + BlancoJavaSourceUtil
                                    .escapeStringAsJavaSource(field
                                            .getDefault()) + "\"");
                } else if (field.getType().equals("boolean")
                        || field.getType().equals("short")
                        || field.getType().equals("int")
                        || field.getType().equals("long")) {
                    field1.setDefault(field.getDefault());
                } else if (field.getType().equals("java.lang.Boolean")
                        || field.getType().equals("java.lang.Integer")
                        || field.getType().equals("java.lang.Long")) {
                    field1.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(field.getType())
                            + "(" + field.getDefault() + ")");
                } else if (field.getType().equals("java.lang.Short")) {
                    field1.setDefault("new "
                            + BlancoNameUtil.trimJavaPackage(field.getType())
                            + "((short) " + field.getDefault() + ")");
                } else if (field.getType().equals("java.math.BigDecimal")) {
                    fCgSourceFile.getImportList().add("java.math.BigDecimal");
                    // 񂩂BigDecimalւƕϊ܂B
                    field1.setDefault("new BigDecimal(\"" + field.getDefault()
                            + "\")");
                } else if (field.getType().equals("java.util.ArrayList")) {
                    // ArrayList̏ꍇɂ́A^ꂽ̂܂܍̗p܂B
                    // TODO 2blancoValueObject̗pꍇɂ́ASNXC|[gÓB
                    fCgSourceFile.getImportList().add("java.util.ArrayList");
                    field1.setDefault(field.getDefault());
                } else {
                    throw new IllegalArgumentException(fBundle
                            .getXml2javaclassErr005(classInfo.getName(), field
                                    .getName(), field.getDefault(), field
                                    .getType()));
                }
            }
            if (field.getJavadoc() != null) {
                final String[] lines = BlancoValueObjectUtil
                        .escapeStringAsJavaDocWithNewLine(field.getJavadoc());
                for (int index = 0; index < lines.length; index++) {
                    field1.getLangDoc().getDescriptionList().add(lines[index]);
                }
            }

            {
                final BlancoCgMethod method = fCgFactory.createMethod("set"
                        + fieldNameAdjustered, fBundle
                        .getXml2javaclassSetJavadoc01(field.getName()));
                fCgClass.getMethodList().add(method);

                if (fEmulateVersion080) {
                    method.setDescription(null);
                    method.getLangDoc().getDescriptionList().add(
                            fBundle.getXml2javaclassSetJavadoc01(field
                                    .getName())
                                    + "<br>");
                }

                // \bh̃VOj`w
                method.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2javaclassSetJavadoc02(field.getType()));
                if (field.getJavadoc() != null) {
                    final String[] lines = BlancoValueObjectUtil
                            .escapeStringAsJavaDocWithNewLine(field
                                    .getJavadoc());
                    for (int index = 0; index < lines.length; index++) {
                        method.getLangDoc().getDescriptionList().add(
                                lines[index]);
                    }
                }

                method.getParameterList().add(
                        fCgFactory.createParameter("arg" + fieldNameAdjustered,
                                field.getType(), fBundle
                                        .getXml2javaclassSetArgJavadoc(field
                                                .getName())));

                // \bh̎
                final List listLine = method.getLineList();

                listLine.add("f" + fieldNameAdjustered + " = " + "arg"
                        + fieldNameAdjustered + ";");
            }

            {
                final BlancoCgMethod method = fCgFactory.createMethod("get"
                        + fieldNameAdjustered, fBundle
                        .getXml2javaclassGetJavadoc01(field.getName()));
                fCgClass.getMethodList().add(method);

                if (fEmulateVersion080) {
                    method.setDescription(null);
                    method.getLangDoc().getDescriptionList().add(
                            fBundle.getXml2javaclassGetJavadoc01(field
                                    .getName())
                                    + "<br>");
                }

                // \bh̃VOj`w
                method.getLangDoc().getDescriptionList().add(
                        fBundle.getXml2javaclassGetJavadoc02(field.getType()));
                if (field.getDefault() != null) {
                    method.getLangDoc().getDescriptionList().add(
                            fBundle.getXml2javaclassGetArgJavadoc(field
                                    .getDefault()));
                }
                if (field.getJavadoc() != null) {
                    final String[] lines = BlancoValueObjectUtil
                            .escapeStringAsJavaDocWithNewLine(field
                                    .getJavadoc());
                    for (int index = 0; index < lines.length; index++) {
                        method.getLangDoc().getDescriptionList().add(
                                lines[index]);
                    }
                }

                method.setReturn(fCgFactory.createReturn(field.getType(),
                        fBundle.getXml2javaclassGetReturnJavadoc(field
                                .getName())));

                // \bh̎
                final List listLine = method.getLineList();

                listLine.add("return f" + fieldNameAdjustered + ";");
            }
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("toString",
                    "̃o[IuWFNg̕\擾܂B");
            fCgClass.getMethodList().add(method);

            method.getLangDoc().getDescriptionList().add(
                    "IuWFNg̃V[͈͂łtoStringȂ_ɒӂėpĂB");

            method.setReturn(fCgFactory.createReturn("java.lang.String",
                    "o[IuWFNg̕\B"));

            final List listLine = method.getLineList();

            listLine.add("final StringBuffer buf = new StringBuffer();");
            listLine.add("buf.append(\"" + classInfo.getPackage() + "."
                    + classInfo.getName() + "[\");");
            for (int indexField = 0; indexField < classInfo.getListField()
                    .size(); indexField++) {
                final BlancoValueObjectFieldStructure field = (BlancoValueObjectFieldStructure) classInfo
                        .getListField().get(indexField);

                final String fieldNameAdjustered = (getNameAdjust() == false ? field
                        .getName()
                        : BlancoNameAdjuster.toClassName(field.getName()));

                if (field.getType().endsWith("[]") == false) {
                    listLine.add("buf.append(\"" + (indexField == 0 ? "" : ",")
                            + field.getName() + "=\" + f" + fieldNameAdjustered
                            + ");");
                } else {
                    // 2006.05.31 t.iga z̏ꍇɂ́A
                    // ̔z񎩐gnullǂ̃`FbNKvłB
                    listLine.add("if (f" + fieldNameAdjustered + " == null) {");
                    // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                    listLine.add("buf.append(" + (indexField == 0 ? "\"" :
                    // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                            "\",") + field.getName() + "=null\");");
                    listLine.add("} else {");

                    // z̏ꍇɂ̓fB[vtoString܂B
                    listLine.add("buf.append("
                    // 0Ԗڂ̍ڂłꍇɂ̓J}Ȃ̓ʈ܂B
                            + (indexField == 0 ? "\"" :
                            // 0Ԗڂł͂Ȃꍇɂ́AɃJ}t^܂B
                                    "\",") + field.getName() + "=[\");");
                    listLine.add("for (int index = 0; index < f"
                            + fieldNameAdjustered + ".length; index++) {");
                    // 2006.05.31 t.iga
                    // ArrayListȂǂtoStringƓlɂȂ悤ɁAJ}̂ƂɔpXy[Xt^悤ɂ܂B
                    listLine.add("buf.append((index == 0 ? \"\" : \", \") + f"
                            + fieldNameAdjustered + "[index]);");
                    listLine.add("}");
                    listLine.add("buf.append(\"]\");");
                    listLine.add("}");
                }
            }
            listLine.add("buf.append(\"]\");");
            listLine.add("return buf.toString();");
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂݒ肵܂B
     * 
     * @param isNameAdjust
     *            Oό`sǂB
     */
    public void setNameAdjust(final boolean isNameAdjust) {
        fNameAdjust = isNameAdjust;
    }

    /**
     * tB[h⃁\bhɂĖOό`sǂ擾܂B
     * 
     * @return Oό`sǂB
     */
    public boolean getNameAdjust() {
        return fNameAdjust;
    }
}
