/*
 * blancoDb
 * Copyright (C) 2004-2005 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.conf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import blanco.ig.expander.Value;

/**
 * @author Yasuo Nakanishi
 */
public class AbstractQuery {
    /**
     * SQL`ID
     */
    private String _name = null;

    /**
     * ̃NG̏ڍ
     */
    private String _description = null;

    private String _query = "";

    private final List _inparameterList = new ArrayList();

    private boolean _single = false;

    public boolean isSingle() {
        return _single;
    }

    public void setSingle(final boolean sigle) {
        _single = sigle;
    }

    public AbstractQuery() {
    }

    public AbstractQuery(final String name) {
        _name = name;
    }

    public void setName(String arg) {
        _name = arg;
    }

    public String getName() {
        return _name;
    }

    public void addInParameter(final Value value) {
        _inparameterList.add(value);
    }

    public String getQuery() {
        return _query;
    }

    public void setQuery(final String query) {
        _query = query;
    }

    public Iterator getInParameterIterator() {
        return _inparameterList.iterator();
    }

    public List getInParameterList() {
        return _inparameterList;
    }

    public String getDescription() {
        return _description;
    }

    public void setDescription(String _description) {
        this._description = _description;
    }
}