/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.anttask;

import java.io.File;
import java.util.List;

import javax.xml.transform.dom.DOMResult;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import blanco.anttask.resourcebundle.BlancoAntTaskResourceBundle;
import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;

/**
 * XMLt@C(^)Java\[XR[h܂B
 * 
 * XMLt@C͂JavaNXE\[XR[h܂B <br>
 * 
 * @author IGA Tosiki
 */
public class BlancoAntTaskXml2JavaClass {
    private final BlancoAntTaskResourceBundle fBundle = new BlancoAntTaskResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@CJava\[XR[h𐶐܂B
     * 
     * @param fileSource
     *            XML^̓t@C
     * @param directoryTarget
     *            \[XR[ho̓fBNg
     */
    public void process(final File fileSource, final File directoryTarget) {
        final DOMResult result = BlancoXmlUtil.transformFile2Dom(fileSource);

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                NodeList listCommon = elementSheet.getElementsByTagName(fBundle
                        .getMeta2xmlElementCommon());
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);
                final String taskName = BlancoXmlUtil.getTextContent(
                        elementCommon, "taskName");
                if (taskName == null || taskName.trim().length() == 0) {
                    // ^XNꍇɂ̓XLbv܂B
                    continue;
                }

                expandSheet(elementSheet, directoryTarget);
            }
        }
    }

    /**
     * w̃V[g̋LqeWJ܂B
     * 
     * @param elementSheet
     *            ΏۂƂV[g
     * @param directoryTarget
     *            o͐fBNg
     */
    private void expandSheet(final Element elementSheet,
            final File directoryTarget) {
        final NodeList listCommon = elementSheet.getElementsByTagName(fBundle
                .getMeta2xmlElementCommon());
        final Element elementCommon = (Element) listCommon.item(0);
        final String taskName = BlancoXmlUtil.getTextContent(elementCommon,
                "taskName");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");
        final String suffix = BlancoXmlUtil.getTextContent(elementCommon,
                "suffix");

        final NodeList listList = elementSheet.getElementsByTagName(fBundle
                .getMeta2xmlElementList());
        if (listList.getLength() == 0) {
            return;
        }

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName,
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                BlancoStringUtil.null2Blank(fBundle.getFilecomment(taskName)));

        fCgClass = fCgFactory.createClass("Abstract"
                + BlancoNameAdjuster.toClassName(taskName)
                + (suffix == null ? "" : suffix), fBundle
                .getClasscomment01(taskName));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.setAbstract(true);

        final List classDescription = fCgClass.getLangDoc()
                .getDescriptionList();

        if (description != null) {
            classDescription.add(BlancoJavaSourceUtil
                    .escapeStringAsJavaDoc(description)
                    + "<br>");
        }
        classDescription.add(fBundle.getClasscomment02());
        classDescription.add(fBundle.getClasscomment03(packageName,
                BlancoNameAdjuster.toClassName(taskName)
                        + (suffix == null ? "" : suffix)));
        classDescription.add("<br>");
        classDescription.add(fBundle.getClasscomment04());
        classDescription.add("<pre>");
        classDescription.add(BlancoJavaSourceUtil
                .escapeStringAsJavaDoc("<taskdef name=\""
                        + taskName.toLowerCase() + "\" classname=\""
                        + packageName + "."
                        + BlancoNameAdjuster.toClassName(taskName)
                        + (suffix == null ? "" : suffix))
                + "\">");
        classDescription.add(BlancoJavaSourceUtil
                .escapeStringAsJavaDoc("    <classpath>"));
        classDescription
                .add(BlancoJavaSourceUtil
                        .escapeStringAsJavaDoc("        <fileset dir=\"lib\" includes=\"*.jar\" />"));
        classDescription
                .add(BlancoJavaSourceUtil
                        .escapeStringAsJavaDoc("        <fileset dir=\"lib.ant\" includes=\"*.jar\" />"));
        classDescription.add(BlancoJavaSourceUtil
                .escapeStringAsJavaDoc("    </classpath>"));
        classDescription.add(BlancoJavaSourceUtil
                .escapeStringAsJavaDoc("</taskdef>"));
        classDescription.add("</pre>");

        fCgClass.getExtendClassList().add(
                fCgFactory.createType("org.apache.tools.ant.Task"));

        {
            final BlancoCgField fieldVerbose = fCgFactory.createField(
                    "fVerbose", "java.lang.String", fBundle
                            .getFieldCommentVerbose());
            fCgClass.getFieldList().add(fieldVerbose);
            fieldVerbose.setDefault("\"false\"");

            final BlancoCgMethod methodSetVerbose = fCgFactory.createMethod(
                    "setVerbose", fBundle.getFieldCommentVerbose());
            fCgClass.getMethodList().add(methodSetVerbose);
            methodSetVerbose.getParameterList().add(
                    fCgFactory.createParameter("arg", "java.lang.String",
                            fBundle.getFieldCommentVerbose()));
            methodSetVerbose.getLineList().add("fVerbose = arg;");

            final BlancoCgMethod methodGetVerbose = fCgFactory.createMethod(
                    "getVerbose", fBundle.getFieldCommentVerbose());
            fCgClass.getMethodList().add(methodGetVerbose);
            methodGetVerbose.setReturn(fCgFactory.createReturn(
                    "java.lang.String", fBundle.getFieldCommentVerbose()));
            methodGetVerbose.getLineList().add("return fVerbose;");
        }

        {
            final Element elementListRoot = (Element) listList.item(0);
            final NodeList listChildNodes = elementListRoot.getChildNodes();
            for (int index = 0; index < listChildNodes.getLength(); index++) {
                final Element elementList = (Element) listChildNodes
                        .item(index);
                final String no = BlancoXmlUtil.getTextContent(elementList,
                        "no");
                final String attribute = BlancoXmlUtil.getTextContent(
                        elementList, "attribute");
                final String isRequire = BlancoXmlUtil.getTextContent(
                        elementList, "isRequire");
                final String attributeDefault = BlancoXmlUtil.getTextContent(
                        elementList, "default");
                final String attributeDescription = BlancoXmlUtil
                        .getTextContent(elementList, "description");

                if (BlancoStringUtil.null2Blank(attribute).length() == 0) {
                    // attributew肳ĂȂꍇɂ͏܂B
                    continue;
                }
                if (isRequire != null && isRequire.trim().length() > 0) {
                    if (attributeDefault != null
                            && attributeDefault.trim().length() > 0) {
                        // ^XN[{0}]AAgr[g[{1}]ɂāA[K{][ftHg]Ɏw肳Ă܂B
                        // [K{][ftHg]͔rIɁAꂩ͎w肷Kv܂B
                        throw new IllegalArgumentException(fBundle
                                .getXml2javaclassErr001(taskName, attribute));
                    }
                }

                final BlancoCgField field1 = fCgFactory.createField("f"
                        + BlancoNameAdjuster.toClassName(attribute),
                        "java.lang.String", fBundle
                                .getFieldComment01(attribute));
                fCgClass.getFieldList().add(field1);
                if (no != null) {
                    field1.getLangDoc().getDescriptionList().add(
                            fBundle.getItemNo() + ": " + no + "<br>");
                }
                if (attributeDescription != null) {
                    field1
                            .getLangDoc()
                            .getDescriptionList()
                            .add(
                                    BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(attributeDescription)
                                            + "<br>");
                }
                if (isRequire != null && isRequire.equals("true")) {
                    field1.getLangDoc().getDescriptionList().add(
                            fBundle.getItemRequired() + "<br>");
                }

                final BlancoCgMethod methodSet = fCgFactory.createMethod("set"
                        + BlancoNameAdjuster.toClassName(attribute), fBundle
                        .getMethodSetComment01(attribute));
                fCgClass.getMethodList().add(methodSet);

                if (no != null) {
                    methodSet.getLangDoc().getDescriptionList().add(
                            fBundle.getItemNo() + ": " + no + "<br>");
                }
                if (attributeDescription != null) {
                    methodSet
                            .getLangDoc()
                            .getDescriptionList()
                            .add(
                                    BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(attributeDescription)
                                            + "<br>");
                }
                methodSet.getParameterList().add(
                        fCgFactory.createParameter("arg", "java.lang.String",
                                fBundle.getMethodSetComment02()));
                methodSet.getLineList().add(
                        "f" + BlancoNameAdjuster.toClassName(attribute)
                                + " = arg;");

                final BlancoCgMethod methodGet = fCgFactory.createMethod("get"
                        + BlancoNameAdjuster.toClassName(attribute), fBundle
                        .getMethodGetComment01(attribute));
                fCgClass.getMethodList().add(methodGet);

                if (no != null) {
                    methodGet.getLangDoc().getDescriptionList().add(
                            fBundle.getItemNo() + ": " + no + "<br>");
                }
                if (attributeDescription != null) {
                    methodGet
                            .getLangDoc()
                            .getDescriptionList()
                            .add(
                                    BlancoJavaSourceUtil
                                            .escapeStringAsJavaDoc(attributeDescription)
                                            + "<br>");
                }
                if (isRequire != null) {
                    methodGet.getLangDoc().getDescriptionList().add(
                            fBundle.getMethodGetComment11());
                }
                if (attributeDefault != null) {
                    methodGet.getLangDoc().getDescriptionList().add(
                            fBundle.getMethodGetComment12(BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(attributeDefault)));
                }

                methodGet.setReturn(fCgFactory.createReturn("java.lang.String",
                        fBundle.getMethodGetComment13()));
                methodGet.getLineList().add(
                        "return f" + BlancoNameAdjuster.toClassName(attribute)
                                + ";");
            }
        }

        final BlancoCgMethod methodProcess = fCgFactory.createMethod("process",
                fBundle.getMethodProcessComment01());
        fCgClass.getMethodList().add(methodProcess);
        methodProcess.setAccess("protected");
        methodProcess.setAbstract(true);
        methodProcess.getThrowList().add(
                fCgFactory.createException(
                        "java.lang.IllegalArgumentException", fBundle
                                .getMethodProcessComment02()));

        {
            final BlancoCgMethod methodExecute = fCgFactory.createMethod(
                    "execute", fBundle.getMethodExecuteComment01());
            fCgClass.getMethodList().add(methodExecute);
            methodExecute.setFinal(true);
            methodExecute.getThrowList().add(
                    fCgFactory.createException(
                            "org.apache.tools.ant.BuildException", fBundle
                                    .getMethodExecuteComment02()));
            final List listLine = methodExecute.getLineList();

            listLine
                    .add("System.out.println(\"" + taskName + "Task begin.\");");
            listLine.add("");

            final Element elementListRoot = (Element) listList.item(0);
            final NodeList listChildNodes = elementListRoot.getChildNodes();
            for (int index = 0; index < listChildNodes.getLength(); index++) {
                final Element elementList = (Element) listChildNodes
                        .item(index);
                final String isRequire = BlancoXmlUtil.getTextContent(
                        elementList, "isRequire");
                if (isRequire == null || isRequire.equals("true") == false) {
                    continue;
                }

                final String no = BlancoXmlUtil.getTextContent(elementList,
                        "no");
                final String attribute = BlancoXmlUtil.getTextContent(
                        elementList, "attribute");
                if (BlancoStringUtil.null2Blank(attribute).length() == 0) {
                    continue;
                }

                listLine.add(fBundle.getMethodExecuteLine01((no == null ? ""
                        : fBundle.getItemNo() + "[" + no + "]A"), attribute));
                listLine.add("if (get"
                        + BlancoNameAdjuster.toClassName(attribute)
                        + "() == null) {");
                listLine.add("throw new BuildException(\""
                        + fBundle.getMethodExecuteLine02(attribute) + "\");");
                listLine.add("}");
            }

            for (int index = 0; index < listChildNodes.getLength(); index++) {
                final Element elementList = (Element) listChildNodes
                        .item(index);
                final String attributeDefault = BlancoXmlUtil.getTextContent(
                        elementList, "default");
                if (attributeDefault == null) {
                    continue;
                }

                final String no = BlancoXmlUtil.getTextContent(elementList,
                        "no");
                final String attribute = BlancoXmlUtil.getTextContent(
                        elementList, "attribute");
                if (BlancoStringUtil.null2Blank(attribute).length() == 0) {
                    continue;
                }

                listLine.add(fBundle.getMethodExecuteLine03((no == null ? ""
                        : fBundle.getItemNo() + "[" + no + "]A"), attribute));
                listLine.add("if (get"
                        + BlancoNameAdjuster.toClassName(attribute)
                        + "() == null) {");
                listLine.add("set"
                        + BlancoNameAdjuster.toClassName(attribute)
                        + "(\""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(attributeDefault)
                        + "\");");
                listLine.add("}");
            }

            listLine.add("");
            listLine.add("if (\"true\".equals(getVerbose())) {");
            listLine.add("System.out.println(\"- verbose:[true]\");");
            for (int index = 0; index < listChildNodes.getLength(); index++) {
                final Element elementList = (Element) listChildNodes
                        .item(index);
                final String attribute = BlancoXmlUtil.getTextContent(
                        elementList, "attribute");
                if (BlancoStringUtil.null2Blank(attribute).length() == 0) {
                    continue;
                }

                listLine.add("System.out.println(\"- " + attribute
                        + ":[\" + get"
                        + BlancoNameAdjuster.toClassName(attribute)
                        + "() + \"]\");");
            }
            listLine.add("}");
            listLine.add("");

            listLine.add("try {");
            listLine.add(fBundle.getMethodExecuteLine04());
            listLine.add("process();");
            listLine.add("} catch (IllegalArgumentException e) {");
            listLine.add("if (\"true\".equals(getVerbose())) {");
            listLine.add("e.printStackTrace();");
            listLine.add("}");
            listLine.add("throw new BuildException(e.getMessage());");
            listLine.add("} catch (Exception e) {");
            listLine.add("e.printStackTrace();");
            listLine.add("throw new BuildException(\""
                    + fBundle.getMethodExecuteLine05() + "\" + e.toString());");
            listLine.add("} catch (Error e) {");
            listLine.add("e.printStackTrace();");
            listLine.add("throw new BuildException(\""
                    + fBundle.getMethodExecuteLine06() + "\" + e.toString());");
            listLine.add("}");
        }

        directoryTarget.mkdirs();

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }
}