/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.util;

import blanco.cg.BlancoCgSupportedLang;
import blanco.commons.util.BlancoStringUtil;

/**
 * blancoCg̃Xe[ggɊւ郆[eBeBłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B<br>
 * 
 * @author IGA Tosiki
 */
class BlancoCgStatementUtil {
    /**
     * if̊Jn̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr
     *            \B
     * @return
     */
    public static final String getIfBegin(final int argTargetLang,
            final String argExpr) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "if (" + argExpr + ") {";
        case BlancoCgSupportedLang.VB:
            return "If (" + argExpr + ") Then";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * if̏I̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return
     */
    public static final String getIfEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "}";
        case BlancoCgSupportedLang.VB:
            return "End If";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * for̊Jn̕擾܂BJava̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr1
     *            B
     * @param argExpr2
     *            pB
     * @param argExpr3
     *            [v̂ǎ{鏈B
     * @return
     */
    public static final String getForBeginJava(final int argTargetLang,
            final String argExpr1, final String argExpr2, final String argExpr3) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "for (" + argExpr1 + "; " + argExpr2 + "; " + argExpr3
                    + ") {";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginJava: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }
    }

    /**
     * for̊Jn̕擾܂BVB.NET̕߂܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @param argStep
     *            StepɗplBu: 2vBnull̏ꍇɂ Step͏ȗ܂B
     * @return
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo, final String argStep) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.VB:
            break;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil.getForBeginVb: T|[gȂvO~O("
                            + argTargetLang + ")^܂B");
        }

        String argLine = "For " + argCounter + " To " + argTo;
        if (BlancoStringUtil.null2Blank(argStep).length() > 0) {
            argLine += " Step " + argStep;
        }

        return argLine;
    }

    /**
     * foȑI̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return
     */
    public static final String getForEnd(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "}";
        case BlancoCgSupportedLang.VB:
            // [vϐ͏ȗ܂B
            return "Next";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * for𔲂邽߂̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return break܂ Exit For߂܂B
     */
    public static final String getForExit(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "break";
        case BlancoCgSupportedLang.VB:
            return "Exit For";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * ̏I(̏ꍇZ~R)擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @return Z~R܂͒0̕߂܂B
     */
    public static final String getTerminator(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return ";";
        case BlancoCgSupportedLang.VB:
            return "";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * return̕擾܂B
     * 
     * @param argTargetLang
     *            o͂ΏۃvO~OB
     * @param argExpr
     *            lB
     * @return Z~R͊܂݂܂B
     */
    public static final String getReturn(final int argTargetLang,
            final String argExpr) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            // ӁBZ~R͊܂݂܂B
            return "return " + argExpr;
        case BlancoCgSupportedLang.VB:
            // [vϐ͏ȗ܂B
            return "Return " + argExpr;
        default:
            throw new IllegalArgumentException(
                    "BlancoCgStatementUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }
}