/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.task;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.db.BlancoDbConstantsDotNet;
import blanco.db.BlancoDbMeta2XmlDotNet;
import blanco.db.BlancoDbXml2CsClassDotNet;
import blanco.db.common.BlancoDbTableMeta2Xml;
import blanco.db.common.stringgroup.BlancoDbExecuteSqlStringGroup;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.resourcebundle.BlancoDbDotNetResourceBundle;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * blancoDbDotNetAnt^XNłB
 * 
 * @author IGA Tosiki
 */
public class BlancoDbDotNetTask extends AbstractBlancoDbDotNetTask {
    /**
     * \[XohANZTIuWFNgL܂B
     */
    private final BlancoDbDotNetResourceBundle fBundle = new BlancoDbDotNetResourceBundle();

    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoDbConstantsDotNet.PRODUCT_NAME + " ("
                + BlancoDbConstantsDotNet.VERSION + ")");

        try {
            System.out.println("db: begin.");
            final long startMills = System.currentTimeMillis();

            final File blancoTmpDbTableDirectory = new File(getTmpdir()
                    + BlancoDbConstantsDotNet.TARGET_SUBDIRECTORY + "/table");
            final File blancoTmpDbSqlDirectory = new File(getTmpdir()
                    + BlancoDbConstantsDotNet.TARGET_SUBDIRECTORY + "/sql");
            blancoTmpDbTableDirectory.mkdirs();
            blancoTmpDbSqlDirectory.mkdirs();

            final BlancoDbSetting dbSetting = new BlancoDbSetting();
            dbSetting.setTargetDir(getTargetdir());
            dbSetting.setBasePackage(getBasepackage());
            dbSetting.setRuntimePackage(getRuntimepackage());

            dbSetting.setJdbcdriver(getJdbcdriver());
            dbSetting.setJdbcurl(getJdbcurl());
            dbSetting.setJdbcuser(getJdbcuser());
            dbSetting.setJdbcpassword(getJdbcpassword());

            if (getLog().equals("true")) {
                dbSetting.setLogging(true);
            }
            if (BlancoStringUtil.null2Blank(getStatementtimeout()).length() > 0) {
                try {
                    dbSetting.setStatementTimeout(Integer
                            .parseInt(getStatementtimeout()));
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(
                            "Xe[gg^CAEglƂĎw肳ꂽl[" + getStatementtimeout()
                                    + "]͐lƂĉ͂ł܂łBf܂B:"
                                    + ex.toString());
                }
            }
            dbSetting.setExecuteSql(new BlancoDbExecuteSqlStringGroup()
                    .convertToInt(getExecutesql()));
            if (dbSetting.getExecuteSql() == BlancoDbExecuteSqlStringGroup.NOT_DEFINED) {
                throw new IllegalArgumentException("executesqlƂĕsȒl("
                        + getExecutesql() + ")^܂B");
            }

            if (getSchema() != null) {
                // XL[}wB
                dbSetting.setSchema(getSchema());
            }

            if (getTable() == null || getTable().equals("true")) {
                // P\ANZT
                final BlancoDbTableMeta2Xml tableMeta2Xml = new BlancoDbTableMeta2Xml() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }

                    protected boolean isSkipTypeForSimpleTable(
                            final BlancoDbMetaDataColumnStructure columnStructure) {
                        // DotNetłł̓oCi^longvarcharʏ̕\ANZXƓɈƂł܂B
                        return false;
                    }
                };
                tableMeta2Xml.setFormatSql(true);
                tableMeta2Xml.process(dbSetting, blancoTmpDbTableDirectory);

                // XMLt@CR/O}bsO
                final BlancoDbXml2CsClassDotNet generator = new BlancoDbXml2CsClassDotNet() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    dbSetting.setLogging(true);
                }
                generator.process(dbSetting, blancoTmpDbTableDirectory);
            }

            if (getSql() == null || getSql().equals("true")) {
                final File fileMetadir = new File(getMetadir());
                if (fileMetadir.exists() == false) {
                    throw new IllegalArgumentException(fBundle
                            .getAnttaskErr001(getMetadir()));
                }

                final BlancoDbMeta2XmlDotNet meta2Xml = new BlancoDbMeta2XmlDotNet();
                meta2Xml.setCacheMeta2Xml(getCache().equals("true"));
                meta2Xml.processDirectory(fileMetadir, blancoTmpDbSqlDirectory
                        .getAbsolutePath());

                // XMLt@CR/O}bsO
                final BlancoDbXml2CsClassDotNet generator = new BlancoDbXml2CsClassDotNet() {
                    public boolean progress(int progressCurrent,
                            int progressTotal, String progressItem) {
                        // trueԂ܂B
                        return true;
                    }
                };
                if (getLog().equals("true")) {
                    dbSetting.setLogging(true);
                }
                generator.process(dbSetting, blancoTmpDbSqlDirectory);
            }

            final long endMills = System.currentTimeMillis() - startMills;
            System.out.println("db: end: " + (endMills / 1000) + " sec.");
        } catch (SQLException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr001()
                    + e.toString());
        } catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(fBundle.getTaskErr002()
                    + e.toString());
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr003()
                    + e.toString());
        } catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr004()
                    + e.toString());
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr005()
                    + e.toString());
        } catch (TransformerException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(fBundle.getTaskErr006()
                    + e.toString());
        }
    }
}
