/*
 * blancoDb Enterprise Edition
 * Copyright (C) 2004-2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.exception;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * f[^x[XbN^CAEgɊւONX
 * 
 * 2007.02.05_ɂāASQL Server 2000/2005̏ꍇɂ̂ ̃NX͗p܂B
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2007.02.05
 * @author IGA Tosiki
 */
public class LockTimeoutExceptionClass {
    /**
     * ONX̃NX
     */
    public static final String CLASS_NAME = "LockTimeoutException";

    /**
     * RXgN^ɎJavaDocB
     */
    private static final String CONSTRUCTOR_JAVADOC = "f[^x[X̃bN^CAEgƂOIuWFNg ̃CX^X쐬܂B";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * o͐ƂȂpbP[WB
     */
    private String fPackage = null;

    public LockTimeoutExceptionClass(final BlancoCgObjectFactory cgFactory,
            final String argPackage) {
        fCgFactory = cgFactory;
        fPackage = argPackage;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        cgClass.getExtendClassList().add(
                fCgFactory.createType(fPackage + ".TimeoutException"));

        {
            final List listDesc = cgClass.getLangDoc().getDescriptionList();

            listDesc.add("f[^x[XbN^CAEgɊւONX <br>");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂ <br>");
            listDesc.add("̃NX́A\[XR[h̃t@CƂėp܂B");
            listDesc.add("");
            listDesc.add("@since 2007.02.05");
            listDesc.add("@author blanco Framework");
        }

        {
            final BlancoCgField cgField = fCgFactory.createField(
                    "SQLSTATE_LOCK_TIMEOUT", "java.lang.String",
                    "̃NX\SQLStateR[hB");
            cgClass.getFieldList().add(cgField);
            cgField.setAccess("protected");
            cgField.setStatic(true);
            cgField.setFinal(true);
            cgField.setDefault("\"HY000\"");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");

            cgMethod
                    .getLineList()
                    .add(
                            "super(\"Lock timeout exception has occured.\", SQLSTATE_LOCK_TIMEOUT);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));

            cgMethod.getLineList().add("super(reason, SQLSTATE_LOCK_TIMEOUT);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod
                    .getLangDoc()
                    .getDescriptionList()
                    .add(
                            "@deprecated ̃RXgN^͂ȂׂpɁAƂ̗OSQLStatevenderCode𗘗p\ȕʂ̃RXgN^𗘗pĂB");
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("SQLState", "java.lang.String",
                            "Oʂ XOPENR[h܂ SQL 99̃R[h"));

            cgMethod.getLineList().add("super(reason, SQLState);");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(CLASS_NAME,
                    CONSTRUCTOR_JAVADOC);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setConstructor(true);
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("reason", "java.lang.String",
                            "O̐"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("SQLState", "java.lang.String",
                            "Oʂ XOPENR[h܂ SQL 99̃R[h"));
            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("vendorCode", "int",
                            "f[^x[Xx_[߂ŗL̗OR[h"));

            cgMethod.getLineList().add("super(reason, SQLState, vendorCode);");
        }

        return fCgSourceFile;
    }
}