/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.charactergroup.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.charactergroup.BlancoCharacterGroupConstants;
import blanco.charactergroup.BlancoCharacterGroupMeta2Xml;
import blanco.charactergroup.BlancoCharacterGroupXml2SourceFile;
import blanco.charactergroup.resourcebundle.BlancoCharacterGroupResourceBundle;

/**
 * uO[v`vExcell當O[vNXE\[XR[h𐶐B
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCharacterGroupTask extends AbstractBlancoCharacterGroupTask {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoCharacterGroupResourceBundle bundle = new BlancoCharacterGroupResourceBundle();

    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoCharacterGroupConstants.PRODUCT_NAME
                + " (" + BlancoCharacterGroupConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(bundle
                        .getAnttaskErr001(getMetadir()));
            }

            // e|fBNg쐬B
            new File(getTmpdir()
                    + BlancoCharacterGroupConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoCharacterGroupMeta2Xml()
                    .processDirectory(fileMetadir, getTmpdir()
                            + BlancoCharacterGroupConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoCharacterGroupConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoCharacterGroupXml2SourceFile().process(
                        fileMeta2[index], getTargetlang(), new File(
                                getTargetdir()));
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}
