/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.hashtable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.hashtable.resourcebundle.BlancoHashtableResourceBundle;
import blanco.hashtable.valueobject.BlancoHashtableInputStructure;
import blanco.hashtable.valueobject.BlancoHashtableStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * unbVe[u`vExcellHashMapNXE\[XR[h𐶐B
 * 
 * ̃NX́AXMLt@C\[XR[h@\S܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoHashtableXml2SourceFile {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoHashtableResourceBundle fBundle = new BlancoHashtableResourceBundle();

    /**
     * o͑ΏۂƂȂvO~OB
     */
    private int fTargetLang = BlancoCgSupportedLang.NOT_DEFINED;

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * XMLt@C\[XR[h܂B
     * 
     * @param argMetaXmlSourceFile
     *            ^񂪊܂܂ĂXMLt@CB
     * @param argTargetLang
     *            o͑ΏۃvO~OB
     * @param argDirectoryTarget
     *            \[XR[hfBNg (/mainw肵܂)B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(final File argMetaXmlSourceFile,
            final String argTargetLang, final File argDirectoryTarget)
            throws IOException {

        fTargetLang = new BlancoCgSupportedLang().convertToInt(argTargetLang);
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
            break;
        default:
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr002(argTargetLang));
        }

        // ^͂ăo[IuWFNg̃c[擾܂B
        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(argMetaXmlSourceFile);

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        final int sizeListSheet = listSheet.size();
        for (int index = 0; index < sizeListSheet; index++) {
            // ̂̂̃V[g܂B
            final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                    .get(index);

            // ʏ擾܂B
            final BlancoXmlElement elementCommon = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle
                            .getMeta2xmlElementCommon());
            if (elementCommon == null) {
                // commonꍇɂ́ÃV[g̏XLbv܂B
                continue;
            }

            final String name = BlancoXmlBindingUtil.getTextContent(
                    elementCommon, "name");
            if (BlancoStringUtil.null2Blank(name).trim().length() == 0) {
                // namȅꍇɂ͏XLbv܂B
                continue;
            }

            // ꗗ擾܂B
            final BlancoXmlElement elementList = BlancoXmlBindingUtil
                    .getElement(elementSheet, fBundle.getMeta2xmlElementList());

            // V[gڍׂȏ擾܂B
            final BlancoHashtableStructure processStructure = parseSheet(
                    elementCommon, elementList, argDirectoryTarget);

            if (processStructure != null) {
                // ^̉͌ʂƂɃ\[XR[hs܂B
                expandSourceFile(processStructure, argDirectoryTarget);
            }
        }
    }

    /**
     * sheetGgWJ܂B
     * 
     * @param argElementCommon
     *            ݏĂCommonm[hB
     * @param argElementList
     *            ݏĂListm[hB
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     * @return Wꂽ^\f[^B
     */
    private BlancoHashtableStructure parseSheet(
            final BlancoXmlElement argElementCommon,
            final BlancoXmlElement argElementList, final File argDirectoryTarget) {

        final BlancoHashtableStructure processStructure = new BlancoHashtableStructure();
        processStructure.setName(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "name"));
        processStructure.setPackage(BlancoXmlBindingUtil.getTextContent(
                argElementCommon, "package"));

        if (BlancoStringUtil.null2Blank(processStructure.getPackage()).trim()
                .length() == 0) {
            throw new IllegalArgumentException(fBundle
                    .getXml2sourceFileErr001(processStructure.getName()));
        }

        if (BlancoXmlBindingUtil
                .getTextContent(argElementCommon, "description") != null) {
            processStructure.setDescription(BlancoXmlBindingUtil
                    .getTextContent(argElementCommon, "description"));
        }

        if (BlancoXmlBindingUtil.getTextContent(argElementCommon, "suffix") != null) {
            processStructure.setSuffix(BlancoXmlBindingUtil.getTextContent(
                    argElementCommon, "suffix"));
        }

        if (argElementList == null) {
            return null;
        }

        // nbVe[u`E͂̓e擾܂B
        final List listField = BlancoXmlBindingUtil.getElementsByTagName(
                argElementList, "field");
        for (int indexField = 0; indexField < listField.size(); indexField++) {
            final Object nodeField = listField.get(indexField);

            if (nodeField instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementField = (BlancoXmlElement) nodeField;
            BlancoHashtableInputStructure input = new BlancoHashtableInputStructure();
            input
                    .setNo(BlancoXmlBindingUtil.getTextContent(elementField,
                            "no"));

            input
                    .setId(BlancoXmlBindingUtil.getTextContent(elementField,
                            "id"));
            if (BlancoStringUtil.null2Blank(input.getId()).length() == 0) {
                continue;
            }
            //
            // field.setValue(BlancoXmlBindingUtil.getTextContent(elementField,
            // "value"));
            // if (BlancoStringUtil.null2Blank(field.getValue()).length() == 0)
            // {
            // // ŌxB
            // continue;
            // }
            //
            // // ɓeo^ĂȂǂ̃`FbNB
            // for (int indexPast = 0; indexPast <
            // processStructure.getListField()
            // .size(); indexPast++) {
            // final BlancoMessageFieldStructure fieldPast =
            // (BlancoMessageFieldStructure) processStructure
            // .getListField().get(indexPast);
            // if (fieldPast.getKey().equals(field.getKey())) {
            // throw new IllegalArgumentException(fBundle
            // .getXml2sourceFileErr003(
            // processStructure.getName(), field.getKey()));
            // }
            // }

            processStructure.getInput().add(input);
        }

        return processStructure;
    }

    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    private void expandSourceFile(
            final BlancoHashtableStructure argProcessStructure,
            final File argDirectoryTarget) {

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(argDirectoryTarget
                .getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(argProcessStructure
                .getPackage(), "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgClass = fCgFactory.createClass(argProcessStructure.getName()
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix()),
                BlancoStringUtil.null2Blank(argProcessStructure
                        .getDescription()));
        fCgSourceFile.getClassList().add(fCgClass);

        expandField(argProcessStructure);
        expandMethodGet(argProcessStructure);
        expandMethodGetMap(argProcessStructure);

        BlancoCgTransformerFactory.getSourceTransformer(fTargetLang).transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * tB[hWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandField(final BlancoHashtableStructure argProcessStructure) {

        final BlancoCgField cgField = fCgFactory.createField("fMap",
                "java.util.HashMap", "IɕێĂ}bvIuWFNgB");
        fCgClass.getFieldList().add(cgField);
        cgField.setAccess("protected");
        cgField.setDefault("new HashMap()");

    }

    /**
     * get \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodGet(
            final BlancoHashtableStructure argProcessStructure) {

        BlancoHashtableInputStructure input = (BlancoHashtableInputStructure) argProcessStructure
                .getInput().get(0);

        final String methodName = "get";

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName(methodName), BlancoCgSourceUtil
                        .escapeStringAsLangDoc(fTargetLang, argProcessStructure
                                .getName()
                                + "ɑΉl擾܂B"));
        fCgClass.getMethodList().add(cgMethod);

        ArrayList parameterList = new ArrayList();
        parameterList.add(fCgFactory.createParameter(input.getId(),
                getTypeString(), input.getName(), true));
        cgMethod.setParameterList(parameterList);
        cgMethod
                .setReturn(fCgFactory.createReturn(getTypeString(), "L[ɑΉl"));

        final List lineList = cgMethod.getLineList();

        lineList.add("final Object objFound = fMap.get(" + input.getId() + ")"
                + BlancoCgLineUtil.getTerminator(fTargetLang));

        lineList.add(BlancoCgLineUtil.getIfBegin(fTargetLang,
                "objFound == null"));

        lineList.add("throw new IllegalArgumentException(\"w肳ꂽL[(\" + "
                + input.getId() + " + \")ɑΉl݂͑܂B\")"
                + BlancoCgLineUtil.getTerminator(fTargetLang));
        lineList.add(BlancoCgLineUtil.getIfEnd(fTargetLang));

        lineList.add("");
        lineList.add("return (String) objFound"
                + BlancoCgLineUtil.getTerminator(fTargetLang));
    }

    /**
     * getMap \bhWJ܂B
     * 
     * @param argProcessStructure
     *            ^t@CWł\f[^B
     */
    private void expandMethodGetMap(
            final BlancoHashtableStructure argProcessStructure) {

        final String methodName = "getMap";

        final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                getMethodName(methodName), BlancoCgSourceUtil
                        .escapeStringAsLangDoc(fTargetLang,
                                "IɕێĂ}bv\I܂B"));
        cgMethod.getLangDoc().getDescriptionList().add("}bv\zۂȂǂɗpĂB");
        cgMethod.setReturn(fCgFactory.createReturn("java.util.HashMap",
                "ɕێĂ}bv"));
        fCgClass.getMethodList().add(cgMethod);

        final List lineList = cgMethod.getLineList();
        lineList.add("return fMap;");
    }

    /**
     * vO~Oꏈnɍ String ^̖̂擾܂B
     * 
     * ^̓ǂݑւB
     * 
     * @return
     */
    private final String getTypeString() {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return "java.lang.String";
        }
    }

    /**
     * vO~Oꏈnɍ \bh̖Oό`Ȃ܂B
     * 
     * \bh̓ǂݑւB
     * 
     * @return
     */
    private final String getMethodName(final String argMethodName) {
        switch (fTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            return argMethodName;
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.VB:
            return BlancoNameAdjuster.toUpperCaseTitle(argMethodName);
        case BlancoCgSupportedLang.JS:
            return argMethodName;
        }
    }
}
