/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.constants.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.constants.BlancoConstantsConstants;
import blanco.constants.BlancoConstantsMeta2Xml;
import blanco.constants.BlancoConstantsXml2JavaClass;
import blanco.constants.resourcebundle.BlancoConstantsResourceBundle;

/**
 * 萔`(XLS)Java\[XR[hAnt^XNłB
 * 
 * ̃NX́AblancoɂĎꂽAAnt^XNۃNXpĂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoConstantsTask extends AbstractBlancoConstantsTask {
    /**
     * \[Xohւ̃ANZTNX̃IuWFNgB
     */
    private final BlancoConstantsResourceBundle fBundle = new BlancoConstantsResourceBundle();

    /**
     * 萔`(XLS)Java\[XR[hAnt^XÑGg|CgłB
     * 
     * ̃NX́AblancoɂĎꂽAAnt^XNۃNXĂяo܂B<br>
     * ۃNXŊe̓`FbNIԂŁÃ\bh͌Ăяo܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoConstantsConstants.PRODUCT_NAME + " ("
                + BlancoConstantsConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            // e|fBNg쐬B
            new File(getTmpdir() + BlancoConstantsConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoConstantsMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoConstantsConstants.TARGET_SUBDIRECTORY);

            // XMLꂽ^t@CValueObject𐶐
            // ŏɃe|tH_𑖍
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoConstantsConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoConstantsXml2JavaClass().process(fileMeta2[index],
                        new File(getTargetdir()));
            }
        } catch (IOException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (TransformerException e) {
            throw new IllegalArgumentException(e.toString());
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw e;
        }
    }
}
