/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.cs;

import java.util.List;

import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgClass\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgClassCsSourceExpander {

    /**
     * ClassWJ܂B
     * 
     * @param cgClass
     *            ΏۂƂȂNXB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformClass(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        // ŏɃNXLangDocɓWJB
        if (cgClass.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgClass.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgClass.getLangDoc().getTitle() == null) {
            cgClass.getLangDoc().setTitle(cgClass.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocCsSourceExpander().transformLangDoc(cgClass
                .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgClass, argSourceLines);

        final StringBuffer buf = new StringBuffer();

        if (BlancoStringUtil.null2Blank(cgClass.getAccess()).length() > 0) {
            buf.append(cgClass.getAccess() + " ");
        }
        if (cgClass.getAbstract()) {
            buf.append("abstract ");
        }
        if (cgClass.getFinal()) {
            buf.append("final ");
        }
        buf.append("class " + cgClass.getName());

        // eNXWJB
        expandExtendClassList(cgClass, argSourceFile, buf);

        // eC^tF[XWJB
        expandImplementInterfaceList(cgClass, argSourceFile, buf);

        // sm肵ďo{B
        argSourceLines.add(buf.toString());

        // NX̃ubN̊JnB
        argSourceLines.add("{");

        // ŃtB[hWJB
        expandFieldList(cgClass, argSourceFile, argSourceLines);

        // Ń\bhWJB
        expandMethodList(cgClass, argSourceFile, argSourceLines);

        // NX̃ubN̏IB
        argSourceLines.add("}");
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgClass
     *            NXB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgClass cgClass,
            final List argSourceLines) {
        for (int index = 0; index < cgClass.getAnnotationList().size(); index++) {
            final Object objAnnotation = cgClass.getAnnotationList().get(index);
            if (objAnnotation instanceof String == false) {
                throw new IllegalArgumentException("NX[" + cgClass.getName()
                        + "]Annotationjava.lang.StringȊǑ^["
                        + objAnnotation.getClass().getName() + "]^܂B");
            }

            final String strAnnotation = (String) objAnnotation;
            // C#.NETAnnotation []ŋLq܂B
            argSourceLines.add("[" + strAnnotation + "]");
        }
    }

    /**
     * eNXWJ܂B
     * 
     * BlancoCgInterfaceWJ̍ۂɁÃ\bhʏƂČĂяoĂ͂Ȃ܂B
     * ̋ʉ́AėWƔfĂ܂B
     * 
     * @param cgClass
     *            NX̃o[IuWFNgB
     * @param argBuf
     *            o͐敶obt@B
     */
    private void expandExtendClassList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final StringBuffer argBuf) {
        for (int index = 0; index < cgClass.getExtendClassList().size(); index++) {
            final Object objType = cgClass.getExtendClassList().get(index);
            if (objType instanceof BlancoCgType == false) {
                throw new IllegalArgumentException("NX̌pƂBlancoCgTypeȊǑ^["
                        + objType.getClass().getName() + "]^܂B");
            }

            final BlancoCgType type = (BlancoCgType) objType;

            // importɌ^ǉB
            argSourceFile.getImportList().add(type.getName());

            if (index == 0) {
                argBuf.append(" : "
                        + BlancoCgTypeCsSourceExpander.toTypeString(type));
            } else {
                // TODO C#.NEŤpx肾ǂmF{邱ƁB
                // throw new
                // IllegalArgumentException("C#.NETł͌p͈񂵂{ł܂B");

                // TODO _ł͑dpOKłƑz肵܂B
                argBuf.append(", "
                        + BlancoCgTypeCsSourceExpander.toTypeString(type));
            }
        }
    }

    /**
     * eC^tF[XWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argBuf
     *            o͐敶obt@B
     */
    private void expandImplementInterfaceList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final StringBuffer argBuf) {
        for (int index = 0; index < cgClass.getImplementInterfaceList().size(); index++) {
            final Object objType = cgClass.getImplementInterfaceList().get(
                    index);
            if (objType instanceof BlancoCgType == false) {
                throw new IllegalArgumentException("NX̎ƂBlancoCgTypeȊǑ^["
                        + objType.getClass().getName() + "]^܂B");
            }

            final BlancoCgType type = (BlancoCgType) objType;

            // importɌ^ǉB
            argSourceFile.getImportList().add(type.getName());

            if (index == 0 && cgClass.getExtendClassList().size() == 0) {
                // ŏ̃C^tF[XŁApꍇ : o͂܂B
                argBuf.append(" : ");
            } else {
                argBuf.append(", ");
            }
            argBuf.append(BlancoCgTypeCsSourceExpander.toTypeString(type));
        }
    }

    /**
     * NXɊ܂܂eX̃tB[hWJ܂B
     * 
     * TODO 萔錾D悵ēWJǍϐ錾WJȂǂ̍HvKvłB<br>
     * ݂ o^Ń\[XR[hWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandFieldList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (cgClass.getFieldList() == null) {
            // tB[h̃Xgnull^܂B
            // Ȃ炸tB[h̃XgɂListZbgĂB
            throw new IllegalArgumentException("tB[h̃Xgnull^܂B");
        }

        for (int index = 0; index < cgClass.getFieldList().size(); index++) {
            final Object objField = cgClass.getFieldList().get(index);
            if (objField instanceof BlancoCgField == false) {
                throw new IllegalArgumentException("tB[h̃XgɃtB[hȊǑ^["
                        + objField.getClass().getName() + "]̒l^܂B");
            }
            final BlancoCgField cgField = (BlancoCgField) objField;
            // NX̃tB[hƂēWJs܂B
            new BlancoCgFieldCsSourceExpander().transformField(cgField,
                    argSourceFile, argSourceLines, false);
        }
    }

    /**
     * NXɊ܂܂eX̃\bhWJ܂B
     * 
     * @param cgClass
     *            ̃NXB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandMethodList(final BlancoCgClass cgClass,
            final BlancoCgSourceFile argSourceFile, final List argSourceLines) {
        if (cgClass.getMethodList() == null) {
            throw new IllegalArgumentException("\bh̃Xgnull^܂B");
        }
        for (int index = 0; index < cgClass.getMethodList().size(); index++) {
            final Object objMethod = cgClass.getMethodList().get(index);
            if (objMethod instanceof BlancoCgMethod == false) {
                throw new IllegalArgumentException("\bh̃XgɃ\bhȊǑ^["
                        + objMethod.getClass().getName() + "]̒l^܂B");
            }

            final BlancoCgMethod cgMethod = (BlancoCgMethod) objMethod;
            // NX̃\bhƂēWJs܂B
            new BlancoCgMethodCsSourceExpander().transformMethod(cgMethod,
                    argSourceFile, argSourceLines, false);
        }
    }
}
