/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.batchprocess;

import java.io.File;
import java.io.IOException;

import blanco.batchprocess.valueobject.BlancoBatchProcessInputItemStructure;
import blanco.batchprocess.valueobject.BlancoBatchProcessStructure;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.valueobject.BlancoValueObjectXml2JavaClass;
import blanco.valueobject.valueobject.BlancoValueObjectClassStructure;
import blanco.valueobject.valueobject.BlancoValueObjectFieldStructure;

/**
 * blancoBatchProcesŝ߂̗ONXo͂܂B
 */
class BlancoBatchProcessExpandValueObject {
    /**
     * WꂽɁA\[XR[h܂B
     * 
     * @param argRuntimePackage
     *            ^t@CWł\f[^B
     * @param argProcessStructure
     * @param argDirectoryTarget
     *            \[XR[h̏o͐tH_B
     */
    public void expandSourceFile(final String argRuntimePackage,
            final BlancoBatchProcessStructure argProcessStructure,
            final File argDirectoryTarget) {
        final BlancoValueObjectClassStructure voStructure = new BlancoValueObjectClassStructure();
        voStructure.setName(getClassName(argProcessStructure));
        voStructure.setPackage(argProcessStructure.getPackage()
                + ".valueobject");
        voStructure.setJavadoc("ob`NX ["
                + BlancoNameAdjuster.toClassName(argProcessStructure.getName())
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix())
                + "]̓̓o[IuWFNgNXłB BlancoResourceBundleAntTaskłB");
        for (int index = 0; index < argProcessStructure.getInputItemList()
                .size(); index++) {
            final BlancoBatchProcessInputItemStructure inputItem = (BlancoBatchProcessInputItemStructure) argProcessStructure
                    .getInputItemList().get(index);

            final BlancoValueObjectFieldStructure voFieldStructure = new BlancoValueObjectFieldStructure();
            voFieldStructure.setName(inputItem.getName());
            voFieldStructure.setType("java.lang.String");
            voFieldStructure.setJavadoc(BlancoJavaSourceUtil
                    .escapeStringAsJavaDoc(BlancoStringUtil
                            .null2Blank(inputItem.getDescription())));
            if (BlancoStringUtil.null2Blank(inputItem.getDefault()).length() > 0) {
                voFieldStructure.setDefault(inputItem.getDefault());
            }
            voStructure.getFieldList().add(voFieldStructure);
        }
        try {
            new BlancoValueObjectXml2JavaClass().structure2Source(voStructure,
                    argDirectoryTarget);
        } catch (IOException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        }
    }

    public static String getClassName(
            final BlancoBatchProcessStructure argProcessStructure) {
        return BlancoNameAdjuster.toClassName(argProcessStructure.getName())
                + BlancoStringUtil.null2Blank(argProcessStructure.getSuffix())
                + "Input";
    }
}
