/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.batchprocess.task;

import blanco.batchprocess.task.valueobject.BlancoBatchProcessBatchProcessInput;

/**
 * ob`NX [BlancoBatchProcessBatchProcess]̒ېeNXB
 *
 * ̃NXp [blanco.batchprocess.task]pbP[W[BlancoBatchProcessBatchProcess]NX쐬Ďۂ̃ob`ĂB
 */
abstract class AbstractBlancoBatchProcessBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractBlancoBatchProcessBatchProcessNXp blanco.batchprocess.taskpbP[W BlancoBatchProcessBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractBlancoBatchProcessBatchProcess batchProcess = new BlancoBatchProcessBatchProcess();

        // ob`̈B
        final BlancoBatchProcessBatchProcessInput input = new BlancoBatchProcessBatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(arg.substring(9));
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-targetlang=")) {
                input.setTargetlang(arg.substring(12));
            } else if (arg.startsWith("-runtimepackage=")) {
                input.setRuntimepackage(arg.substring(16));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoBatchProcessBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hB
     */
    public abstract int process(final BlancoBatchProcessBatchProcessInput input);

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hB
     */
    public final int execute(final BlancoBatchProcessBatchProcessInput input) {
        try {
            if (input.getMetadir() == null) {
                System.out.println("BlancoBatchProcessBatchProcess: JnsBK{̓̓p[^[metadir]ݒ肳Ă܂B");
                System.exit(END_ILLEGAL_ARGUMENT);
            }

            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoBatchProcessBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("BlancoBatchProcessBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoBatchProcessBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoBatchProcessBatchProcess: Usage:");
        System.out.println("  java blanco.batchprocess.task.BlancoBatchProcessBatchProcess -verbose=l1 -metadir=l2 -targetdir=l3 -tmpdir=l4 -targetlang=l5 -runtimepackage=l6");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("    -metadir");
        System.out.println("      [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]");
        System.out.println("      K{p[^B");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("    -targetlang");
        System.out.println("      [^[QbgƂȂvO~OꏈnBjava, cs, jsI\]");
        System.out.println("    -runtimepackage");
        System.out.println("      [^CNX𐶐鐶w肵܂Bw̏ꍇɂ `̒lɐ܂B]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
