/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.anttask.task;

import blanco.anttask.task.valueobject.BlancoAntTaskBatchProcessInput;

/**
 */
public abstract class AbstractBlancoAntTaskBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * Gg|CgB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // AbstractBlancoAntTaskBatchProcessNXpblanco.anttask.taskpbP[WBlancoAntTaskBatchProcessNX쐬܂B
        final AbstractBlancoAntTaskBatchProcess batchProcess = new BlancoAntTaskBatchProcess();

        // ob`̈B
        final BlancoAntTaskBatchProcessInput input = new BlancoAntTaskBatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(arg.substring(9));
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoAntTaskBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (input.getMetadir() == null) {
            System.out.println("BlancoAntTaskBatchProcess: JnsBK{̓̓p[^[metadir]ݒ肳Ă܂B");
            usage();
            System.exit(END_ERROR);
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ob`eLq郁\bhB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input
     * @return ob`̏IR[hB
     */
    public abstract int process(final BlancoAntTaskBatchProcessInput input);

    /**
     * ob`sۂɌĂяo܂B
     *
     * @param input
     * @return ob`̏IR[hB
     */
    public final int execute(final BlancoAntTaskBatchProcessInput input) {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoAntTaskBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("BlancoAntTaskBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoAntTaskBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * g̐B
     */
    public static final void usage() {
        System.out.println("BlancoAntTaskBatchProcess: Usage:");
        System.out.println("  java blanco.anttask.task.BlancoAntTaskBatchProcess -verbose=l1 -metadir=l2 -targetdir=l3 -tmpdir=l4");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("    -metadir");
        System.out.println("      [^t@Ci[fBNgw肵܂B]");
        System.out.println("      K{p[^B");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|tH_w肵܂Bw̏ꍇɂ́AJgtmpp܂B]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
