package blanco.anttask.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.anttask.BlancoAntTaskConstants;
import blanco.anttask.BlancoAntTaskMeta2Xml;
import blanco.anttask.BlancoAntTaskXml2JavaClass;
import blanco.anttask.resourcebundle.BlancoAntTaskResourceBundle;
import blanco.anttask.task.valueobject.BlancoAntTaskBatchProcessInput;

public class BlancoAntTaskBatchProcess extends
        AbstractBlancoAntTaskBatchProcess {
    private final BlancoAntTaskResourceBundle fBundle = new BlancoAntTaskResourceBundle();

    public int process(final BlancoAntTaskBatchProcessInput input) {
        System.out.println("- " + BlancoAntTaskConstants.PRODUCT_NAME + " ("
                + BlancoAntTaskConstants.VERSION + ")");

        try {
            final File blancoTmpAntTaskDirectory = new File(input.getTmpdir()
                    + BlancoAntTaskConstants.TARGET_SUBDIRECTORY);
            blancoTmpAntTaskDirectory.mkdirs();

            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr002(input.getMetadir()));
            }

            new BlancoAntTaskMeta2Xml().processDirectory(fileMetadir,
                    blancoTmpAntTaskDirectory.getAbsolutePath());

            final File[] fileTmp = blancoTmpAntTaskDirectory.listFiles();
            if (fileTmp == null) {
                // ̗Rɂt@Cꗗ̎擾ɎsꍇB
                throw new IllegalArgumentException(fBundle
                        .getXml2javaclassErr003(blancoTmpAntTaskDirectory
                                .getAbsolutePath()));
            }

            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoAntTaskXml2JavaClass().process(fileTmp[index],
                            new File(input.getTargetdir()));
                }
            }
        } catch (TransformerException e) {
            System.out.println(e.toString());
            return END_ERROR;
        } catch (IOException e) {
            System.out.println(e.toString());
            return END_ERROR;
        }
        return END_SUCCESS;
    }
}
