/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.batchprocess;

import blanco.sample.batchprocess.valueobject.Sample2BatchProcessInput;

/**
 * ob`NX [Sample2BatchProcess]̒ېeNXB
 *
 * ̃NXp [blanco.sample.batchprocess]pbP[W[Sample2BatchProcess]NX쐬Ďۂ̃ob`ĂB
 */
abstract class AbstractSample2BatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractSample2BatchProcessNXp blanco.sample.batchprocesspbP[W Sample2BatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractSample2BatchProcess batchProcess = new Sample2BatchProcess();

        // ob`̈B
        final Sample2BatchProcessInput input = new Sample2BatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-require=")) {
                input.setRequire(arg.substring(9));
            } else if (arg.startsWith("-dispstr=")) {
                input.setDispstr(arg.substring(9));
            } else if (arg.startsWith("-normalparam=")) {
                input.setNormalparam(arg.substring(13));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("Sample2BatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public abstract int process(final Sample2BatchProcessInput input);

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public final int execute(final Sample2BatchProcessInput input) {
        try {
            System.out.println("Sample2BatchProcess: begin");

            if (input.getRequire() == null) {
                System.out.println("Sample2BatchProcess: JnsBK{̓̓p[^[require]ݒ肳Ă܂B");
                System.exit(END_ILLEGAL_ARGUMENT);
            }

            // ob`̖{̂s܂B
            int retCode = process(input);

            System.out.println("Sample2BatchProcess: end (" + retCode + ")");
            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("Sample2BatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("Sample2BatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("Sample2BatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("Sample2BatchProcess: Usage:");
        System.out.println("  java blanco.sample.batchprocess.Sample2BatchProcess -require=l1 -dispstr=l2 -normalparam=l3");
        System.out.println("    -require");
        System.out.println("      [K{̃TvB]");
        System.out.println("      K{p[^B");
        System.out.println("    -dispstr");
        System.out.println("      [\̃TvB]");
        System.out.println("      ftHgl[Ɏw肪ꍇ̕]");
        System.out.println("    -normalparam");
        System.out.println("      [K{łȂA܂ftHgȂ̗B]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
