/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.batchprocess;

import blanco.sample.batchprocess.valueobject.SampleBatchProcessInput;

/**
 * ob`NX [SampleBatchProcess]̒ېeNXB
 *
 * ̃NXp [blanco.sample.batchprocess]pbP[W[SampleBatchProcess]NX쐬Ďۂ̃ob`ĂB
 */
abstract class AbstractSampleBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ob`OIBIBatchProcessExceptionꍇB
     */
    public static final int END_BATCHPROCESS_EXCEPTION = 7;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractSampleBatchProcessNXp blanco.sample.batchprocesspbP[W SampleBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractSampleBatchProcess batchProcess = new SampleBatchProcess();

        // ob`̈B
        final SampleBatchProcessInput input = new SampleBatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-require=")) {
                input.setRequire(arg.substring(9));
            } else if (arg.startsWith("-dispstr=")) {
                input.setDispstr(arg.substring(9));
            } else if (arg.startsWith("-normalparam=")) {
                input.setNormalparam(arg.substring(13));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("SampleBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public abstract int process(final SampleBatchProcessInput input);

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBȈꍇ0Bُ͈Ȉꍇ8BُȈꍇ9B
     */
    public final int execute(final SampleBatchProcessInput input) {
        try {
            System.out.println("SampleBatchProcess: begin");

            if (input.getRequire() == null) {
                System.out.println("SampleBatchProcess: JnsBK{̓̓p[^[require]ݒ肳Ă܂B");
                System.exit(END_ILLEGAL_ARGUMENT);
            }

            // ob`̖{̂s܂B
            int retCode = process(input);

            System.out.println("SampleBatchProcess: end (" + retCode + ")");
            return retCode;
        } catch (BlancoBatchProcessException ex) {
            System.out.println("SampleBatchProcess: ob`O܂Bob`𒆒f܂B:" + ex.toString());
            // ob`OIB
            return END_BATCHPROCESS_EXCEPTION;
        } catch (IllegalArgumentException ex) {
            System.out.println("SampleBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("SampleBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("SampleBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("SampleBatchProcess: Usage:");
        System.out.println("  java blanco.sample.batchprocess.SampleBatchProcess -require=l1 -dispstr=l2 -normalparam=l3");
        System.out.println("    -require");
        System.out.println("      [K{̃TvB]");
        System.out.println("      K{p[^B");
        System.out.println("    -dispstr");
        System.out.println("      [\̃TvB]");
        System.out.println("      ftHgl[Ɏw肪ꍇ̕]");
        System.out.println("    -normalparam");
        System.out.println("      [K{łȂA܂ftHgȂ̗B]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
