/*
 * blanco Framework
 * Copyright (C) 2004-2007 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.log;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.SimpleDateFormat;
import java.util.Date;

import blanco.commons.util.BlancoStreamUtil;
import blanco.log.resourcebundle.BlancoLogMessageResourceBundle;

/**
 * blancoLog: oCiOo͂邽߂̃NXB
 * 
 * @author IGA Tosiki
 */
public class BlancoLogBinaryLogger {
    /**
     * blancoLogbZ[WNXB
     */
    protected final BlancoLogMessageResourceBundle fMsg = new BlancoLogMessageResourceBundle();

    /**
     * t@C̈ꕔ𖽖Ƃɗp܂B
     * 
     * ̃IuWFNg ̃NX̃bNIuWFNgƂĂpĂ܂B
     */
    private static final SimpleDateFormat sdFormat = new SimpleDateFormat(
            "yyyyMMddHHmmss.SSS");

    /**
     * fBNgɗp܂B
     */
    private static final SimpleDateFormat sdYmdFormat = new SimpleDateFormat(
            "yyyyMMdd");

    /**
     * fBNgB̃fBNgzɔNfBNg쐬B
     */
    protected String fBaseDirectory;

    /**
     * Ot@C̃vtBbNXB
     */
    protected String fPrefix;

    /**
     * Ot@C̃TtBbNXB
     */
    protected String fSuffix;

    /**
     * Ot@C̊gqB
     */
    protected String fExt;

    /**
     * 
     * @param argBaseDirectory
     * @param argPrefix
     * @param argSuffix
     * @param argExt
     */
    public BlancoLogBinaryLogger(final String argBaseDirectory,
            final String argPrefix, final String argSuffix, final String argExt) {
        // tB[h\̉邩ǂ邱ƁB
        fBaseDirectory = argBaseDirectory;
        fPrefix = argPrefix;
        fSuffix = argSuffix;
        fExt = argExt;
    }

    /**
     * oCif[^̃fBNg̏̕t@CւƏ݂܂B
     * 
     * @param argBinaryData
     *            ݂soCif[^B
     * @return OƂďot@CB
     * @throws IOException
     */
    public File log(final byte[] argBinaryData) throws IOException {
        // ̏ŗp錻ݎ肵܂B
        final Date dateCurrent = new Date();

        final File fileBaseDirectory = new File(fBaseDirectory);
        if (fileBaseDirectory.exists() == false) {
            if (fileBaseDirectory.mkdirs() == false) {
                throw new IOException(fMsg.getMblgb001(fileBaseDirectory
                        .getAbsolutePath()));
            }
        }

        synchronized (sdFormat) {
            // : ̉ӏ̓VOɓ삷悤ɃubN{Ă܂B
            // JavaVM̏ꍇɂ́At@CՓ˂̖܂B

            final String baseYmdDirectory = fileBaseDirectory.getAbsolutePath()
                    + "/" + sdYmdFormat.format(dateCurrent);
            final File fileBaseYmdDirectory = new File(baseYmdDirectory);
            if (fileBaseYmdDirectory.exists() == false) {
                if (fileBaseYmdDirectory.mkdirs() == false) {
                    throw new IOException(fMsg.getMblgb002(fileBaseYmdDirectory
                            .getAbsolutePath()));
                }
            }

            final String targetFilenameBase = baseYmdDirectory + "/" + fPrefix
                    + sdFormat.format(dateCurrent) + fSuffix + ".";

            File fileOutputLogfile = new File(targetFilenameBase + fExt);
            if (fileOutputLogfile.exists()) {
                // t@Cɂ΁AAԏŏՓ˂
                for (int index = 1;; index++) {
                    // ӁB݂͖[vn̎łB
                    fileOutputLogfile = new File(targetFilenameBase
                            + String.valueOf(index) + "." + fExt);
                    if (fileOutputLogfile.exists() == false) {
                        break;
                    }
                }
            }

            // TODO ̊ԂɃt@CVK쐬ƗOŐт܂B̓_ɒӁB

            try {
                if (fileOutputLogfile.createNewFile() == false) {
                    // createNewFile ͐Vt@C atomic ɐ܂B
                    throw new IOException(fMsg.getMblgb003(fileOutputLogfile
                            .getAbsolutePath()));
                }
            } catch (IOException ex) {
                throw new IOException(fMsg.getMblgb004(fileOutputLogfile
                        .getAbsolutePath(), ex.toString()));
            } catch (SecurityException ex) {
                throw new IOException(fMsg.getMblgb005(fileOutputLogfile
                        .getAbsolutePath(), ex.toString()));
            }

            try {
                if (fileOutputLogfile.canWrite() == false) {
                    throw new IOException(fMsg.getMblgb006(fileOutputLogfile
                            .getAbsolutePath()));
                }
            } catch (SecurityException ex) {
                throw new IOException(fMsg.getMblgb007(fileOutputLogfile
                        .getAbsolutePath(), ex.toString()));

            }

            // 擾t@CɃOeꊇ]B

            try {
                final FileOutputStream outStream = new FileOutputStream(
                        fileOutputLogfile);
                final FileChannel outputChannel = outStream.getChannel();
                FileLock lock = null;
                try {
                    lock = outputChannel.lock();
                } catch (IOException ex) {
                    throw new IOException(fMsg.getMblgb009(fileOutputLogfile
                            .getAbsolutePath(), ex.toString()));
                }

                try {
                    BlancoStreamUtil.copy(new ByteArrayInputStream(
                            argBinaryData), outStream);
                    outStream.flush();
                } finally {
                    try {
                        lock.release();
                    } catch (IOException ex) {
                        throw new IOException(fMsg.getMblgb010(
                                fileOutputLogfile.getAbsolutePath(), ex
                                        .toString()));
                    }

                    try {
                        outputChannel.close();
                    } catch (IOException ex) {
                        throw new IOException(fMsg.getMblgb011(
                                fileOutputLogfile.getAbsolutePath(), ex
                                        .toString()));
                    }

                    try {
                        outStream.close();
                    } catch (IOException ex) {
                        throw new IOException(fMsg.getMblgb012(
                                fileOutputLogfile.getAbsolutePath(), ex
                                        .toString()));
                    }
                }
            } catch (IOException ex) {
                throw new IOException(fMsg.getMblgb008(fileOutputLogfile
                        .getAbsolutePath(), ex.toString()));
            }

            return fileOutputLogfile;
        }
    }
}
