/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.sample.batchprocess;

import java.io.IOException;
import java.math.BigDecimal;

import blanco.sample.batchprocess.valueobject.Sample2BatchProcessInput;

/**
 * ob`NX [Sample2BatchProcess]̒ېeNXB̃NX̓pbP[WANZXɌ肳Ă܂ (publicNXł͂܂)B
 *
 * ̃NXp [blanco.sample.batchprocess]pbP[W[Sample2BatchProcess]NX쐬Ďۂ̃ob`ĂB<br>
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.sample.batchprocess.Sample2BatchProcess -help
 * </code>
 */
abstract class AbstractSample2BatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 97;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 98;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 99;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractSample2BatchProcessNXp blanco.sample.batchprocesspbP[W Sample2BatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractSample2BatchProcess batchProcess = new Sample2BatchProcess();

        // ob`̈B
        final Sample2BatchProcessInput input = new Sample2BatchProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldRequireProcessed = false;
        boolean isFieldFieldIntReqProcessed = false;
        boolean isFieldFieldLongReqProcessed = false;
        boolean isFieldFieldDecimalReqProcessed = false;
        boolean isFieldFieldBooleanReqProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-require=")) {
                input.setRequire(arg.substring(9));
                isFieldRequireProcessed = true;
            } else if (arg.startsWith("-dispstr=")) {
                input.setDispstr(arg.substring(9));
            } else if (arg.startsWith("-normalparam=")) {
                input.setNormalparam(arg.substring(13));
            } else if (arg.startsWith("-field_int_req=")) {
                try {
                    input.setFieldIntReq(Integer.parseInt(arg.substring(15)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_int_req]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldFieldIntReqProcessed = true;
            } else if (arg.startsWith("-field_int=")) {
                try {
                    input.setFieldInt(Integer.parseInt(arg.substring(11)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_int]𐔒l(int)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-field_long_req=")) {
                try {
                    input.setFieldLongReq(Long.parseLong(arg.substring(16)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_long_req]𐔒l(long)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldFieldLongReqProcessed = true;
            } else if (arg.startsWith("-field_long=")) {
                try {
                    input.setFieldLong(Long.parseLong(arg.substring(12)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_long]𐔒l(long)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-field_decimal_req=")) {
                try {
                    input.setFieldDecimalReq(new BigDecimal(arg.substring(19)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_decimal_req]𐔒l(decimal)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
                isFieldFieldDecimalReqProcessed = true;
            } else if (arg.startsWith("-field_decimal=")) {
                try {
                    input.setFieldDecimal(new BigDecimal(arg.substring(15)));
                } catch (NumberFormatException e) {
                    System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̃tB[h[field_decimal]𐔒l(decimal)Ƃăp[X݂܂s܂B: " + e.toString());
                    System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
                }
            } else if (arg.startsWith("-field_boolean_req=")) {
                input.setFieldBooleanReq(Boolean.valueOf(arg.substring(19)).booleanValue());
                isFieldFieldBooleanReqProcessed = true;
            } else if (arg.startsWith("-field_boolean=")) {
                input.setFieldBoolean(Boolean.valueOf(arg.substring(15)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("Sample2BatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldRequireProcessed == false) {
            System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[require]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldFieldIntReqProcessed == false) {
            System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[field_int_req]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldFieldLongReqProcessed == false) {
            System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[field_long_req]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldFieldDecimalReqProcessed == false) {
            System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[field_decimal_req]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldFieldBooleanReqProcessed == false) {
            System.out.println("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[field_boolean_req]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂BȈꍇ0B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public abstract int process(final Sample2BatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂BȈꍇ0B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final Sample2BatchProcessInput input) throws IllegalArgumentException {
        try {
            System.out.println("Sample2BatchProcess: begin");

            // ̓p[^`FbN܂B
            validateInput(input);

            // ob`̖{̂s܂B
            int retCode = process(input);

            System.out.println("Sample2BatchProcess: end (" + retCode + ")");
            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("Sample2BatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("Sample2BatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("Sample2BatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("Sample2BatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("Sample2BatchProcess: Usage:");
        System.out.println("  java blanco.sample.batchprocess.Sample2BatchProcess -require=l1 -dispstr=l2 -normalparam=l3 -field_int_req=l4 -field_int=l5 -field_long_req=l6 -field_long=l7 -field_decimal_req=l8 -field_decimal=l9 -field_boolean_req=l10 -field_boolean=l11");
        System.out.println("    -require");
        System.out.println("      [K{̃TvB]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -dispstr");
        System.out.println("      [\̃TvB]");
        System.out.println("      ^[]");
        System.out.println("      ftHgl[Ɏw肪ꍇ̕]");
        System.out.println("    -normalparam");
        System.out.println("      [K{łȂA܂ftHgȂ̗B]");
        System.out.println("      ^[]");
        System.out.println("    -field_int_req");
        System.out.println("      ^[l(int)]");
        System.out.println("      K{p[^");
        System.out.println("    -field_int");
        System.out.println("      ^[l(int)]");
        System.out.println("    -field_long_req");
        System.out.println("      ^[l(long)]");
        System.out.println("      K{p[^");
        System.out.println("    -field_long");
        System.out.println("      ^[l(long)]");
        System.out.println("    -field_decimal_req");
        System.out.println("      ^[l(decimal)]");
        System.out.println("      K{p[^");
        System.out.println("    -field_decimal");
        System.out.println("      ^[l(decimal)]");
        System.out.println("    -field_boolean_req");
        System.out.println("      ^[^U]");
        System.out.println("      K{p[^");
        System.out.println("    -field_boolean");
        System.out.println("      ^[^U]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final Sample2BatchProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getRequire() == null) {
            throw new IllegalArgumentException("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[require]ɒlݒ肳Ă܂B");
        }
        if (input.getFieldDecimalReq() == null) {
            throw new IllegalArgumentException("Sample2BatchProcess: JnsB̓p[^[input]̕K{tB[hl[field_decimal_req]ɒlݒ肳Ă܂B");
        }
    }
}
