/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.valueobject.task;

import blanco.valueobject.task.valueobject.BlancoValueObjectBatchProcessInput;

/**
 */
public abstract class AbstractBlancoValueObjectBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * Gg|CgB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // AbstractBlancoValueObjectBatchProcessNXpblanco.valueobject.taskpbP[WBlancoValueObjectBatchProcessNX쐬܂B
        final AbstractBlancoValueObjectBatchProcess batchProcess = new BlancoValueObjectBatchProcess();

        // ob`̈B
        final BlancoValueObjectBatchProcessInput input = new BlancoValueObjectBatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(arg.substring(9));
            } else if (arg.startsWith("-metadir=")) {
                input.setMetadir(arg.substring(9));
            } else if (arg.startsWith("-targetdir=")) {
                input.setTargetdir(arg.substring(11));
            } else if (arg.startsWith("-tmpdir=")) {
                input.setTmpdir(arg.substring(8));
            } else if (arg.startsWith("-nameAdjust=")) {
                input.setNameAdjust(arg.substring(12));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoValueObjectBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (input.getMetadir() == null) {
            System.out.println("BlancoValueObjectBatchProcess: JnsBK{̓̓p[^[metadir]ݒ肳Ă܂B");
            usage();
            System.exit(END_ERROR);
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ob`eLq郁\bhB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input
     * @return ob`̏IR[hB
     */
    public abstract int process(final BlancoValueObjectBatchProcessInput input);

    /**
     * ob`sۂɌĂяo܂B
     *
     * @param input
     * @return ob`̏IR[hB
     */
    public final int execute(final BlancoValueObjectBatchProcessInput input) {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoValueObjectBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT;
        } catch (RuntimeException ex) {
            System.out.println("BlancoValueObjectBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoValueObjectBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * g̐B
     */
    public static final void usage() {
        System.out.println("BlancoValueObjectBatchProcess: Usage:");
        System.out.println("  java blanco.valueobject.task.BlancoValueObjectBatchProcess -verbose=l1 -metadir=l2 -targetdir=l3 -tmpdir=l4 -nameAdjust=l5");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("    -metadir");
        System.out.println("      [^fBNgBxlst@C̊i[܂ xmlt@C̊i[w肵܂B]");
        System.out.println("      K{p[^B");
        System.out.println("    -targetdir");
        System.out.println("      [o͐tH_w肵܂Bw̏ꍇɂ̓Jgblancop܂B]");
        System.out.println("    -tmpdir");
        System.out.println("      [e|fBNgw肵܂Bw̏ꍇɂ̓Jgtmpp܂B]");
        System.out.println("    -nameAdjust");
        System.out.println("      [tB[h⃁\bh𖼑Oό`{邩ǂB]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }
}
