/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.uno.launcher.task;

import java.io.IOException;

import blanco.uno.launcher.task.valueobject.BlancoUnoLauncherStartBatchProcessInput;

/**
 * ob`NX [BlancoUnoLauncherStartBatchProcess]̒ېeNXB̃NX̓pbP[WANZXɌ肳Ă܂ (publicNXł͂܂)B
 *
 * ̃NXp [blanco.uno.launcher.task]pbP[W[BlancoUnoLauncherStartBatchProcess]NX쐬Ďۂ̃ob`ĂB<br>
 *
 * ob`̌ĂяoB
 * <code>
 * java -classpath (NXpX) blanco.uno.launcher.task.BlancoUnoLauncherStartBatchProcess -help
 * </code>
 */
abstract class AbstractBlancoUnoLauncherStartBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        // ̉ӏŃRpCG[ꍇAAbstractBlancoUnoLauncherStartBatchProcessNXp blanco.uno.launcher.taskpbP[W BlancoUnoLauncherStartBatchProcessNX쐬邱Ƃɂłꍇ܂B
        final AbstractBlancoUnoLauncherStartBatchProcess batchProcess = new BlancoUnoLauncherStartBatchProcess();

        // ob`̈B
        final BlancoUnoLauncherStartBatchProcessInput input = new BlancoUnoLauncherStartBatchProcessInput();

        boolean isNeedUsage = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-loadmodule=")) {
                input.setLoadmodule(arg.substring(12));
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoUnoLauncherStartBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public abstract int process(final BlancoUnoLauncherStartBatchProcessInput input) throws IOException, IllegalArgumentException;

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoUnoLauncherStartBatchProcessInput input) throws IllegalArgumentException {
        try {
            // ̓p[^`FbN܂B
            validateInput(input);

            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoUnoLauncherStartBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoUnoLauncherStartBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoUnoLauncherStartBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoUnoLauncherStartBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoUnoLauncherStartBatchProcess: Usage:");
        System.out.println("  java blanco.uno.launcher.task.BlancoUnoLauncherStartBatchProcess -verbose=l1 -loadmodule=l2");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -loadmodule");
        System.out.println("      [OpenOffice.org ̃[hW[w肵܂Bw肪Ȃꍇ̓vpeBt@CɋLڂ̂lp܂B]");
        System.out.println("      ^[]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoUnoLauncherStartBatchProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
    }
}
