/*
 * blanco Framework Copyright (C) 2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.uno;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;

import blanco.report.message.BlancoReportMessage;
import blanco.report.resourcebundle.BlancoUnoResourceBundle;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.NoConnectException;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

/**
 * UNOC^tF[X𗘗pۂ̋ʓIȏS܂B<br>
 * ̓Iɂ UNOoRt@C̓ǂݍ݂ƏoS܂B<br>
 * ̃C^tF[Xs邽߂ɂ OpenOffice.org 2.0ȍ~KvłB
 * 
 * @author IGA Tosiki
 */
public class BlancoUnoInstance {
    /**
     * bZ[WB
     */
    private final BlancoReportMessage fMsg = new BlancoReportMessage();

    private final BlancoUnoResourceBundle bundle = new BlancoUnoResourceBundle();

    /**
     * UNOڑŗp\PbgRlNV
     */
    protected XConnection fConnection = null;

    /**
     * ǂݍ܂ꂽR|[lg
     */
    protected XComponent fComponent = null;

    /**
     * UNOڑ̐ڑgCő
     */
    private int fConnectRetryMaxCount = 30;

    /**
     * UNOڑ̐ڑgCȂۂɑҋ@b
     */
    private int fConnectRetryWaitSecond = 1;

    /**
     * RlNVm̍ő僊gC񐔂ݒ肵܂B
     * 
     * @param arg
     *            ő僊gC񐔁B
     */
    public void setConnectRetryMaxCount(final int arg) {
        fConnectRetryMaxCount = arg;
    }

    public void setConnectRetryWaitSecond(final int arg) {
        fConnectRetryWaitSecond = arg;
    }

    /**
     * w肳ꂽt@C[h܂B
     * 
     * @param fileSource
     *            [h̓t@C
     * @param isShowOpenOfficeWindow
     *            ϊOpenOffice.org̃EChE\邩ǂ
     * @throws IllegalArgumentException
     *             ǂݍݎɔeO
     */
    public void load(final File fileSource, final boolean isShowOpenOfficeWindow)
            throws IllegalArgumentException {
        if (fConnection != null) {
            throw new IllegalArgumentException(fMsg.getMbrptu01());
        }
        if (fComponent != null) {
            throw new IllegalArgumentException(fMsg.getMbrptu02());
        }
        if (fileSource.exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbrptu03(fileSource
                    .getAbsolutePath()));
        }

        // ǂݍ݂̂߂̑Os܂B
        final XBridge bridge = createBridgeConnection(bundle
                .getUnoConnectionString());
        final Object desktop = createLocalDesktopInstance(bridge);
        final XComponentLoader componentLoader = (XComponentLoader) UnoRuntime
                .queryInterface(XComponentLoader.class, desktop);

        // hLgۂɃ[h܂B
        final PropertyValue[] loadProps = new PropertyValue[1];
        loadProps[0] = new PropertyValue();
        loadProps[0].Name = "Hidden";
        loadProps[0].Value = new Boolean(!isShowOpenOfficeWindow);
        try {
            fComponent = componentLoader.loadComponentFromURL(
                    file2url(fileSource), "_blank", 0, loadProps);
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu04(ex.toString()));
        } catch (com.sun.star.lang.IllegalArgumentException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu05(ex.toString()));
        }
    }

    /**
     * ۑ܂B
     * 
     * @param filterName
     *            "StarOffice XML (Calc)" Ȃǂw
     * @param fileTarget
     * @throws MalformedURLException
     * @throws IOException
     * @throws com.sun.star.io.IOException
     * @throws IllegalArgumentException
     */
    public void save(final String filterName, final File fileTarget) {
        if (fConnection == null) {
            throw new IllegalArgumentException(fMsg.getMbrptu06());
        }
        if (fComponent == null) {
            throw new IllegalArgumentException(fMsg.getMbrptu07());
        }
        if (fileTarget.exists()) {
            if (fileTarget.delete() == false) {
                throw new IllegalArgumentException(fMsg.getMbrptu08(fileTarget
                        .getAbsolutePath()));
            }
        }

        // ۑ̂߂̑Os܂B
        final XStorable storable = (XStorable) UnoRuntime.queryInterface(
                XStorable.class, fComponent);

        // ۂ̕ۑs܂B
        final PropertyValue[] saveProps = new PropertyValue[1];
        saveProps[0] = new PropertyValue();
        saveProps[0].Name = "FilterName";
        saveProps[0].Value = filterName;
        try {
            storable.storeToURL(file2url(fileTarget), saveProps);
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu09(ex.toString()));
        }

        // R|[lgj܂B
        fComponent.dispose();
        fComponent = null;

        // UNOڑN[Y܂B
        try {
            fConnection.close();
            fConnection = null;
        } catch (com.sun.star.io.IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu10(ex.toString()));
        }

        Logger.getLogger("blanco.uno").finest(
                "ExcelubNVK쐬ăt@Cۑ̈ȀI܂.");
    }

    // ͓Iɗp郁\bh

    /**
     * FileURLɕϊ܂B<br>
     * ȂAUNO [file:///] n܂URLłȂ̂ŁA̖OɂĒs܂B
     * 
     * @param fileTarget
     *            ϊFileIuWFNg
     * @return ϊURL
     */
    private final String file2url(final File fileTarget) {
        try {
            String url = fileTarget.getCanonicalFile().toURL().toString();
            if (url.indexOf("file:///") >= 0) {
                return url;
            }
            url = url.replaceAll("file:/", "file:///");
            if (url.startsWith("file:///") == false) {
                throw new IllegalArgumentException(fMsg.getMbrptu11(url));
            }
            return url;
        } catch (MalformedURLException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu12(ex.toString()));
        } catch (IOException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu13(ex.toString()));
        }
    }

    /**
     * OpenOfficւ̃ubWڑ(UNOڑ)I[v܂
     * 
     * @param connectionString
     *            ڑ
     * @return ubWڑ
     * @throws IllegalArgumentException
     */
    protected XBridge createBridgeConnection(final String connectionString)
            throws IllegalArgumentException {
        Logger.getLogger("blanco.uno").finest(
                "OpenOfficւ̃ubWڑ(UNOڑ)I[v܂.");

        final XComponentContext localContext;
        try {
            localContext = Bootstrap.createInitialComponentContext(null);
        } catch (Exception ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu14(ex.toString()));
        }
        final XMultiComponentFactory localServiceManager = localContext
                .getServiceManager();
        XConnector connector = null;
        try {
            connector = (XConnector) UnoRuntime.queryInterface(
                    XConnector.class, localServiceManager
                            .createInstanceWithContext(
                                    "com.sun.star.connection.Connector",
                                    localContext));
        } catch (Exception ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu15(ex.toString()));
        }

        // UNOڑ̂̂Jn܂B
        //  UNOڑ̊jƂȂ镔łB
        connectUno(connectionString, connector);

        // [gڑ̂߂̃ubW擾܂B
        XBridgeFactory bridgeFactory = null;
        try {
            bridgeFactory = (XBridgeFactory) UnoRuntime.queryInterface(
                    XBridgeFactory.class, localServiceManager
                            .createInstanceWithContext(
                                    "com.sun.star.bridge.BridgeFactory",
                                    localContext));
        } catch (Exception ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu16(ex.toString()));
        }
        try {
            return bridgeFactory.createBridge("", "urp", fConnection, null);
        } catch (BridgeExistsException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu17(ex.toString()));
        } catch (com.sun.star.lang.IllegalArgumentException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu18(ex.toString()));
        }
    }

    /**
     * UNOڑ̂̂Jn܂B
     * 
     *  UNOڑ̊jƂȂ镔łB
     * 
     * @param connectionString
     *            ڑB
     * @param connector
     *            RlN^B
     * @throws IllegalArgumentException
     *             UNOڑɎsꍇȂ
     */
    private void connectUno(final String connectionString, XConnector connector) {
        try {
            for (int retryCount = 1;; retryCount++) {
                try {
                    fConnection = connector.connect(connectionString);
                } catch (NoConnectException ex) {
                    if (retryCount > fConnectRetryMaxCount) {
                        // ő僊gCɓBĂ܂ꍇ͗OX[܂B
                        throw new IllegalArgumentException(fMsg.getMbrptu19(
                                connectionString, ex.toString()));
                    } else {
                        // ēxڑ݂܂B
                        Logger.getLogger("blanco.uno").info(
                                fMsg.getMbrptu20(String.valueOf(retryCount),
                                        String.valueOf(fConnectRetryMaxCount)));
                        Thread.sleep(fConnectRetryWaitSecond * 1000);
                        continue;
                    }
                }
                // ڑ܂B[v𗣒E܂B
                break;
            }
        } catch (InterruptedException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu21(ex.toString()));
        } catch (ConnectionSetupException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu22(ex.toString()));
        }
    }

    /**
     * OpenOffice[JfXNgbvCX^X쐬܂.<br>
     * ̃\bhUNORlNVڑɎs܂B
     * 
     * @param bridge
     *            ubWڑ
     * @return [JfXNgbvIuWFNg
     * @throws IllegalArgumentException
     */
    protected Object createLocalDesktopInstance(final XBridge bridge)
            throws IllegalArgumentException {
        Logger.getLogger("blanco.uno").finest("OpenOfficẽfXNgbvCX^X쐬܂.");

        final XMultiComponentFactory serviceManager = (XMultiComponentFactory) UnoRuntime
                .queryInterface(XMultiComponentFactory.class, bridge
                        .getInstance("StarOffice.ServiceManager"));
        final XPropertySet propertySet = (XPropertySet) UnoRuntime
                .queryInterface(XPropertySet.class, serviceManager);
        XComponentContext remoteContext = null;
        try {
            remoteContext = (XComponentContext) UnoRuntime.queryInterface(
                    XComponentContext.class, propertySet
                            .getPropertyValue("DefaultContext"));
        } catch (UnknownPropertyException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu23(ex.toString()));
        } catch (WrappedTargetException ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu24(ex.toString(),
                    ex.getCause().toString()));
        }
        final XMultiComponentFactory remoteServiceManager = remoteContext
                .getServiceManager();
        try {
            return remoteServiceManager.createInstanceWithContext(
                    "com.sun.star.frame.Desktop", remoteContext);
        } catch (Exception ex) {
            throw new IllegalArgumentException(fMsg.getMbrptu25(ex.toString()));
        }
    }
}
